/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.api.TargetImage;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.event.EventHandlers;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class Containerizer {
    private final TargetImage targetImage;
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private CacheConfiguration cacheConfiguration;
    @Nullable
    private EventHandlers eventHandlers;

    public static Containerizer to(RegistryImage registryImage) {
        return new Containerizer(registryImage);
    }

    public static Containerizer to(DockerDaemonImage dockerDaemonImage) {
        return new Containerizer(dockerDaemonImage);
    }

    public static Containerizer to(TarImage tarImage) {
        return new Containerizer(tarImage);
    }

    private Containerizer(TargetImage targetImage) {
        this.targetImage = targetImage;
    }

    public Containerizer setExecutorService(@Nullable ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Containerizer setCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
        return this;
    }

    public Containerizer setEventHandlers(EventHandlers eventHandlers) {
        this.eventHandlers = eventHandlers;
        return this;
    }

    TargetImage getTargetImage() {
        return this.targetImage;
    }

    Optional<ExecutorService> getExecutorService() {
        return Optional.ofNullable(this.executorService);
    }

    Optional<CacheConfiguration> getCacheConfiguration() {
        return Optional.ofNullable(this.cacheConfiguration);
    }

    Optional<EventHandlers> getEventHandlers() {
        return Optional.ofNullable(this.eventHandlers);
    }
}

