/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RegistryAuthenticator {
    private final String authenticationUrlBase;
    @Nullable
    private Authorization authorization;

    @Nullable
    static RegistryAuthenticator fromAuthenticationMethod(String authenticationMethod, String repository) throws RegistryAuthenticationFailedException, MalformedURLException {
        if (authenticationMethod.matches("^Basic .*")) {
            return null;
        }
        if (!authenticationMethod.matches("^Bearer .*")) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(authenticationMethod, "Bearer");
        }
        Pattern realmPattern = Pattern.compile("realm=\"(.*?)\"");
        Matcher realmMatcher = realmPattern.matcher(authenticationMethod);
        if (!realmMatcher.find()) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(authenticationMethod, "realm");
        }
        String realm = realmMatcher.group(1);
        Pattern servicePattern = Pattern.compile("service=\"(.*?)\"");
        Matcher serviceMatcher = servicePattern.matcher(authenticationMethod);
        if (!serviceMatcher.find()) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(authenticationMethod, "service");
        }
        String service = serviceMatcher.group(1);
        return new RegistryAuthenticator(realm, service, repository);
    }

    private static RegistryAuthenticationFailedException newRegistryAuthenticationFailedException(String authenticationMethod, String authParam) {
        return new RegistryAuthenticationFailedException("'" + authParam + "' was not found in the 'WWW-Authenticate' header, tried to parse: " + authenticationMethod);
    }

    RegistryAuthenticator(String realm, String service, String repository) throws MalformedURLException {
        this.authenticationUrlBase = realm + "?service=" + service + "&scope=repository:" + repository + ":";
    }

    public RegistryAuthenticator setAuthorization(@Nullable Authorization authorization) {
        this.authorization = authorization;
        return this;
    }

    public Authorization authenticatePull() throws RegistryAuthenticationFailedException {
        return this.authenticate("pull");
    }

    public Authorization authenticatePush() throws RegistryAuthenticationFailedException {
        return this.authenticate("pull,push");
    }

    @VisibleForTesting
    URL getAuthenticationUrl(String scope) throws MalformedURLException {
        return new URL(this.authenticationUrlBase + scope);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Authorization authenticate(String scope) throws RegistryAuthenticationFailedException {
        try {
            URL authenticationUrl = this.getAuthenticationUrl(scope);
            try (Connection connection = new Connection(authenticationUrl);){
                Response response;
                String responseString;
                AuthenticationResponseTemplate responseJson;
                Request.Builder requestBuilder = Request.builder();
                if (this.authorization != null) {
                    requestBuilder.setAuthorization(this.authorization);
                }
                if ((responseJson = JsonTemplateMapper.readJson(responseString = Blobs.writeToString((response = connection.get(requestBuilder.build())).getBody()), AuthenticationResponseTemplate.class)).token == null) {
                    throw new RegistryAuthenticationFailedException("Did not get token in authentication response from " + authenticationUrl);
                }
                Authorization authorization = Authorizations.withBearerToken(responseJson.token);
                return authorization;
            }
        }
        catch (IOException ex) {
            throw new RegistryAuthenticationFailedException(ex);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AuthenticationResponseTemplate
    implements JsonTemplate {
        @Nullable
        private String token;

        private AuthenticationResponseTemplate() {
        }
    }
}

