/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.BuildStepsRunner;
import com.google.cloud.tools.jib.frontend.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.maven.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenBuildLogger;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dockerBuild", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildDockerMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "dockerBuild";
    private static final String USER_AGENT_SUFFIX = "jib-maven-plugin";
    private static final HelpfulSuggestions HELPFUL_SUGGESTIONS = HelpfulSuggestionsProvider.get("Build to Docker daemon failed");

    public void execute() throws MojoExecutionException {
        if (!new DockerClient().isDockerInstalled()) {
            throw new MojoExecutionException(HELPFUL_SUGGESTIONS.forDockerNotInstalled());
        }
        ImageReference baseImage = BuildDockerMojo.parseBaseImageReference(this.getBaseImage());
        ImageReference targetImage = Strings.isNullOrEmpty((String)this.getTargetImage()) ? ImageReference.of(null, this.getProject().getName(), this.getProject().getVersion()) : BuildDockerMojo.parseTargetImageReference(this.getTargetImage());
        MavenSettingsServerCredentials mavenSettingsServerCredentials = new MavenSettingsServerCredentials(((MavenSession)Preconditions.checkNotNull((Object)this.session)).getSettings());
        RegistryCredentials knownBaseRegistryCredentials = mavenSettingsServerCredentials.retrieve(baseImage.getRegistry());
        MavenBuildLogger mavenBuildLogger = new MavenBuildLogger(this.getLog());
        MavenProjectProperties mavenProjectProperties = MavenProjectProperties.getForProject(this.getProject(), mavenBuildLogger);
        String mainClass = mavenProjectProperties.getMainClass(this);
        BuildConfiguration buildConfiguration = BuildConfiguration.builder(mavenBuildLogger).setBaseImage(baseImage).setBaseImageCredentialHelperName(this.getBaseImageCredentialHelperName()).setKnownBaseRegistryCredentials(knownBaseRegistryCredentials).setTargetImage(targetImage).setMainClass(mainClass).setJavaArguments(this.getArgs()).setJvmFlags(this.getJvmFlags()).setEnvironment(this.getEnvironment()).build();
        MavenProjectProperties.disableHttpLogging();
        RegistryClient.setUserAgentSuffix(USER_AGENT_SUFFIX);
        try {
            BuildStepsRunner.forBuildToDockerDaemon(buildConfiguration, mavenProjectProperties.getSourceFilesConfiguration(), mavenProjectProperties.getCacheDirectory(), this.getUseOnlyProjectCache()).build(HELPFUL_SUGGESTIONS);
            this.getLog().info((CharSequence)"");
        }
        catch (BuildStepsExecutionException | CacheDirectoryCreationException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
    }
}

