/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class ImageToJsonTranslator {
    private final Image<CachedLayer> image;

    public ImageToJsonTranslator(Image<CachedLayer> image) {
        this.image = image;
    }

    public Blob getContainerConfigurationBlob() {
        ContainerConfigurationTemplate template = new ContainerConfigurationTemplate();
        for (CachedLayer layer : this.image.getLayers()) {
            template.addLayerDiffId(layer.getDiffId());
        }
        template.setContainerEnvironment((List<String>)this.image.getEnvironment());
        template.setContainerEntrypoint((List<String>)this.image.getEntrypoint());
        template.setContainerCmd((List<String>)this.image.getJavaArguments());
        return JsonTemplateMapper.toBlob(template);
    }

    public <T extends BuildableManifestTemplate> T getManifestTemplate(Class<T> manifestTemplateClass, BlobDescriptor containerConfigurationBlobDescriptor) {
        try {
            BuildableManifestTemplate template = (BuildableManifestTemplate)manifestTemplateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DescriptorDigest containerConfigurationDigest = containerConfigurationBlobDescriptor.getDigest();
            long containerConfigurationSize = containerConfigurationBlobDescriptor.getSize();
            template.setContainerConfiguration(containerConfigurationSize, containerConfigurationDigest);
            for (CachedLayer layer : this.image.getLayers()) {
                template.addLayer(layer.getBlobDescriptor().getSize(), layer.getBlobDescriptor().getDigest());
            }
            return (T)template;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException(manifestTemplateClass + " cannot be instantiated", ex);
        }
    }
}

