/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ImageReference {
    private static final String DOCKER_HUB_REGISTRY = "registry.hub.docker.com";
    private static final String DEFAULT_TAG = "latest";
    private static final String LIBRARY_REPOSITORY_PREFIX = "library/";
    private static final String REGISTRY_COMPONENT_REGEX = "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))";
    private static final String REGISTRY_REGEX = String.format("%s(?:\\.%s)*(?::\\d+)?", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))");
    private static final String REPOSITORY_COMPONENT_REGEX = "[a-z\\d]+(?:(?:[_.]|__|[-]*)[a-z\\d]+)*";
    private static final String REPOSITORY_REGEX = String.format("(?:%s/)*%s", "[a-z\\d]+(?:(?:[_.]|__|[-]*)[a-z\\d]+)*", "[a-z\\d]+(?:(?:[_.]|__|[-]*)[a-z\\d]+)*");
    private static final String TAG_REGEX = "[\\w][\\w.-]{0,127}";
    private static final String REFERENCE_REGEX = String.format("^(?:(%s)/)?(%s)(?:(?::(%s))|(?:@(%s)))?$", REGISTRY_REGEX, REPOSITORY_REGEX, "[\\w][\\w.-]{0,127}", "sha256:[a-f0-9]{64}");
    private static final Pattern REFERENCE_PATTERN = Pattern.compile(REFERENCE_REGEX);
    private final String registry;
    private final String repository;
    private final String tag;

    public static ImageReference parse(String reference) throws InvalidImageReferenceException {
        Matcher matcher = REFERENCE_PATTERN.matcher(reference);
        if (!matcher.find() || matcher.groupCount() < 4) {
            throw new InvalidImageReferenceException(reference);
        }
        String registry = matcher.group(1);
        String repository = matcher.group(2);
        String tag = matcher.group(3);
        String digest = matcher.group(4);
        if (Strings.isNullOrEmpty((String)registry)) {
            registry = DOCKER_HUB_REGISTRY;
        }
        if (Strings.isNullOrEmpty((String)repository)) {
            throw new InvalidImageReferenceException(reference);
        }
        if (!(registry.contains(".") || registry.contains(":") || "localhost".equals(registry))) {
            repository = registry + "/" + repository;
            registry = DOCKER_HUB_REGISTRY;
        }
        if (DOCKER_HUB_REGISTRY.equals(registry) && repository.indexOf(47) < 0) {
            repository = LIBRARY_REPOSITORY_PREFIX + repository;
        }
        if (!Strings.isNullOrEmpty((String)tag)) {
            if (!Strings.isNullOrEmpty((String)digest)) {
                throw new InvalidImageReferenceException(reference);
            }
        } else {
            tag = !Strings.isNullOrEmpty((String)digest) ? digest : DEFAULT_TAG;
        }
        return new ImageReference(registry, repository, tag);
    }

    public static ImageReference of(@Nullable String registry, String repository, @Nullable String tag) {
        if (Strings.isNullOrEmpty((String)registry)) {
            registry = DOCKER_HUB_REGISTRY;
        }
        if (Strings.isNullOrEmpty((String)tag)) {
            tag = DEFAULT_TAG;
        }
        return new ImageReference(registry, repository, tag);
    }

    public static boolean isValidRegistry(String registry) {
        return registry.matches(REGISTRY_REGEX);
    }

    public static boolean isValidRepository(String repository) {
        return repository.matches(REPOSITORY_REGEX);
    }

    public static boolean isValidTag(String tag) {
        return tag.matches(TAG_REGEX);
    }

    private ImageReference(String registry, String repository, String tag) {
        this.registry = registry;
        this.repository = repository;
        this.tag = tag;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean usesDefaultTag() {
        return DEFAULT_TAG.equals(this.tag);
    }

    public String toString() {
        StringBuilder referenceString = new StringBuilder();
        if (!DOCKER_HUB_REGISTRY.equals(this.registry)) {
            referenceString.append(this.registry).append('/').append(this.repository);
        } else if (this.repository.startsWith(LIBRARY_REPOSITORY_PREFIX)) {
            referenceString.append(this.repository.substring(LIBRARY_REPOSITORY_PREFIX.length()));
        } else {
            referenceString.append(this.repository);
        }
        if (!DEFAULT_TAG.equals(this.tag)) {
            referenceString.append(':').append(this.tag);
        }
        return referenceString.toString();
    }

    public String toStringWithTag() {
        return this + (this.usesDefaultTag() ? ":latest" : "");
    }
}

