/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.credentials.DockerConfigCredentialRetriever;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class RetrieveRegistryCredentialsStep
implements AsyncStep<Authorization>,
Callable<Authorization> {
    private static final String DESCRIPTION = "Retrieving registry credentials for %s";
    private static final ImmutableMap<String, String> COMMON_CREDENTIAL_HELPERS = ImmutableMap.of((Object)"gcr.io", (Object)"gcr", (Object)"amazonaws.com", (Object)"ecr-login");
    private final BuildLogger buildLogger;
    private final String registry;
    @Nullable
    private final String credentialHelperSuffix;
    @Nullable
    private final RegistryCredentials knownRegistryCredentials;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;
    private final DockerConfigCredentialRetriever dockerConfigCredentialRetriever;
    private final ListenableFuture<Authorization> listenableFuture;

    static RetrieveRegistryCredentialsStep forBaseImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getBuildLogger(), buildConfiguration.getBaseImageRegistry(), buildConfiguration.getBaseImageCredentialHelperName(), buildConfiguration.getKnownBaseRegistryCredentials());
    }

    static RetrieveRegistryCredentialsStep forTargetImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getBuildLogger(), buildConfiguration.getTargetImageRegistry(), buildConfiguration.getTargetImageCredentialHelperName(), buildConfiguration.getKnownTargetRegistryCredentials());
    }

    @VisibleForTesting
    RetrieveRegistryCredentialsStep(ListeningExecutorService listeningExecutorService, BuildLogger buildLogger, String registry, @Nullable String credentialHelperSuffix, @Nullable RegistryCredentials knownRegistryCredentials, DockerCredentialHelperFactory dockerCredentialHelperFactory, DockerConfigCredentialRetriever dockerConfigCredentialRetriever) {
        this.buildLogger = buildLogger;
        this.registry = registry;
        this.credentialHelperSuffix = credentialHelperSuffix;
        this.knownRegistryCredentials = knownRegistryCredentials;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
        this.dockerConfigCredentialRetriever = dockerConfigCredentialRetriever;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    private RetrieveRegistryCredentialsStep(ListeningExecutorService listeningExecutorService, BuildLogger buildLogger, String registry, @Nullable String credentialHelperSuffix, @Nullable RegistryCredentials knownRegistryCredentials) {
        this(listeningExecutorService, buildLogger, registry, credentialHelperSuffix, knownRegistryCredentials, new DockerCredentialHelperFactory(registry), new DockerConfigCredentialRetriever(registry));
    }

    @Override
    public ListenableFuture<Authorization> getFuture() {
        return this.listenableFuture;
    }

    /*
     * Loose catch block
     */
    @Override
    @Nullable
    public Authorization call() throws IOException, NonexistentDockerCredentialHelperException {
        Throwable throwable;
        Timer ignored;
        block32: {
            Authorization authorization;
            block36: {
                block33: {
                    block30: {
                        Authorization authorization2;
                        block35: {
                            block31: {
                                block28: {
                                    Authorization authorization3;
                                    block34: {
                                        block29: {
                                            this.buildLogger.lifecycle(String.format(DESCRIPTION, this.registry) + "...");
                                            ignored = new Timer(this.buildLogger, String.format(DESCRIPTION, this.registry));
                                            throwable = null;
                                            if (this.credentialHelperSuffix == null || (authorization2 = this.retrieveFromCredentialHelper(this.credentialHelperSuffix)) == null) break block28;
                                            authorization3 = authorization2;
                                            if (throwable == null) break block29;
                                            try {
                                                ignored.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            break block34;
                                        }
                                        ignored.close();
                                    }
                                    return authorization3;
                                }
                                if (this.knownRegistryCredentials == null) break block30;
                                this.logGotCredentialsFrom(this.knownRegistryCredentials.getCredentialSource());
                                authorization2 = this.knownRegistryCredentials.getAuthorization();
                                if (throwable == null) break block31;
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block35;
                            }
                            ignored.close();
                        }
                        return authorization2;
                    }
                    Authorization dockerConfigAuthorization = this.dockerConfigCredentialRetriever.retrieve();
                    if (dockerConfigAuthorization == null) break block32;
                    this.buildLogger.info("Using credentials from Docker config for " + this.registry);
                    authorization = dockerConfigAuthorization;
                    if (throwable == null) break block33;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block36;
                }
                ignored.close();
            }
            return authorization;
        }
        try {
            block37: {
                break block37;
                catch (IOException ex) {
                    this.buildLogger.info("Unable to parse Docker config");
                }
            }
            for (String registrySuffix : COMMON_CREDENTIAL_HELPERS.keySet()) {
                if (!this.registry.endsWith(registrySuffix)) continue;
                try {
                    String commonCredentialHelper = (String)COMMON_CREDENTIAL_HELPERS.get((Object)registrySuffix);
                    if (commonCredentialHelper == null) {
                        throw new IllegalStateException("No COMMON_CREDENTIAL_HELPERS should be null");
                    }
                    Authorization authorization = this.retrieveFromCredentialHelper(commonCredentialHelper);
                    if (authorization == null) continue;
                    Authorization authorization4 = authorization;
                    return authorization4;
                }
                catch (NonexistentDockerCredentialHelperException ex) {
                    if (ex.getMessage() == null) continue;
                    this.buildLogger.warn(ex.getMessage());
                }
            }
            this.buildLogger.info("No credentials could be retrieved for registry " + this.registry);
            UnmodifiableIterator unmodifiableIterator = null;
            return unmodifiableIterator;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        catch (Throwable throwable6) {
            throw throwable6;
        }
        finally {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable7) {
                    throwable.addSuppressed(throwable7);
                }
            } else {
                ignored.close();
            }
        }
    }

    @Nullable
    @VisibleForTesting
    Authorization retrieveFromCredentialHelper(String credentialHelperSuffix) throws NonexistentDockerCredentialHelperException, IOException {
        this.buildLogger.info("Checking credentials from docker-credential-" + credentialHelperSuffix);
        try {
            Authorization authorization = this.dockerCredentialHelperFactory.withCredentialHelperSuffix(credentialHelperSuffix).retrieve();
            this.logGotCredentialsFrom("docker-credential-" + credentialHelperSuffix);
            return authorization;
        }
        catch (NonexistentServerUrlDockerCredentialHelperException ex) {
            this.buildLogger.info("No credentials for " + this.registry + " in docker-credential-" + credentialHelperSuffix);
            return null;
        }
    }

    private void logGotCredentialsFrom(String credentialSource) {
        this.buildLogger.info("Using " + credentialSource + " for " + this.registry);
    }
}

