/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CacheReader;
import com.google.cloud.tools.jib.cache.CacheWriter;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.ReproducibleLayerBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;

class BuildAndCacheApplicationLayerStep
implements AsyncStep<CachedLayer>,
Callable<CachedLayer> {
    private static final String DESCRIPTION = "Building application layers";
    private final String layerType;
    private final BuildConfiguration buildConfiguration;
    private final ImmutableList<Path> sourceFiles;
    private final String extractionPath;
    private final Cache cache;
    private final ListenableFuture<CachedLayer> listenableFuture;

    static ImmutableList<BuildAndCacheApplicationLayerStep> makeList(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration, Cache cache) {
        try (Timer ignored = new Timer(buildConfiguration.getBuildLogger(), DESCRIPTION);){
            ImmutableList immutableList = ImmutableList.of((Object)new BuildAndCacheApplicationLayerStep("dependencies", listeningExecutorService, buildConfiguration, sourceFilesConfiguration.getDependenciesFiles(), sourceFilesConfiguration.getDependenciesPathOnImage(), cache), (Object)new BuildAndCacheApplicationLayerStep("resources", listeningExecutorService, buildConfiguration, sourceFilesConfiguration.getResourcesFiles(), sourceFilesConfiguration.getResourcesPathOnImage(), cache), (Object)new BuildAndCacheApplicationLayerStep("classes", listeningExecutorService, buildConfiguration, sourceFilesConfiguration.getClassesFiles(), sourceFilesConfiguration.getClassesPathOnImage(), cache));
            return immutableList;
        }
    }

    private BuildAndCacheApplicationLayerStep(String layerType, ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ImmutableList<Path> sourceFiles, String extractionPath, Cache cache) {
        this.layerType = layerType;
        this.buildConfiguration = buildConfiguration;
        this.sourceFiles = sourceFiles;
        this.extractionPath = extractionPath;
        this.cache = cache;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<CachedLayer> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public CachedLayer call() throws IOException, LayerPropertyNotFoundException, CacheMetadataCorruptedException {
        String description = "Building " + this.layerType + " layer";
        this.buildConfiguration.getBuildLogger().lifecycle(description + "...");
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), description);){
            CachedLayer cachedLayer = new CacheReader(this.cache).getUpToDateLayerBySourceFiles(this.sourceFiles);
            if (cachedLayer != null) {
                CachedLayer cachedLayer2 = cachedLayer;
                return cachedLayer2;
            }
            ReproducibleLayerBuilder reproducibleLayerBuilder = new ReproducibleLayerBuilder((List<Path>)this.sourceFiles, this.extractionPath);
            cachedLayer = new CacheWriter(this.cache).writeLayer(reproducibleLayerBuilder);
            this.buildConfiguration.getBuildLogger().debug(description + " built " + cachedLayer.getBlobDescriptor().getDigest());
            CachedLayer cachedLayer3 = cachedLayer;
            return cachedLayer3;
        }
    }
}

