/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.builder.Timer;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.event.events.TimerEvent;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.time.Clock;
import java.time.Duration;
import javax.annotation.Nullable;

public class TimerEventDispatcher
implements Closeable {
    private static final Clock DEFAULT_CLOCK = Clock.systemUTC();
    private final EventHandlers eventHandlers;
    private final String description;
    private final Clock clock;
    private final Timer timer;

    public TimerEventDispatcher(EventHandlers eventHandlers, String description) {
        this(eventHandlers, description, DEFAULT_CLOCK, null);
    }

    @VisibleForTesting
    TimerEventDispatcher(EventHandlers eventHandlers, String description, Clock clock, @Nullable Timer parentTimer) {
        this.eventHandlers = eventHandlers;
        this.description = description;
        this.clock = clock;
        this.timer = new Timer(clock, parentTimer);
        this.dispatchTimerEvent(TimerEvent.State.START, Duration.ZERO, description);
    }

    public TimerEventDispatcher subTimer(String description) {
        return new TimerEventDispatcher(this.eventHandlers, description, this.clock, this.timer);
    }

    public void lap() {
        this.dispatchTimerEvent(TimerEvent.State.LAP, this.timer.lap(), this.description);
    }

    public void lap(String newDescription) {
        this.dispatchTimerEvent(TimerEvent.State.LAP, this.timer.lap(), newDescription);
    }

    @Override
    public void close() {
        this.dispatchTimerEvent(TimerEvent.State.FINISHED, this.timer.lap(), this.description);
    }

    private void dispatchTimerEvent(TimerEvent.State state, Duration duration, String eventDescription) {
        this.eventHandlers.dispatch(new TimerEvent(state, this.timer, duration, this.timer.getElapsedTime(), eventDescription));
    }
}

