/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.FailoverHttpClient;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.OciManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

public class BuildContext
implements Closeable {
    private static final Class<? extends BuildableManifestTemplate> DEFAULT_TARGET_FORMAT = V22ManifestTemplate.class;
    private static final String DEFAULT_TOOL_NAME = "jib";
    private final ImageConfiguration baseImageConfiguration;
    private final ImageConfiguration targetImageConfiguration;
    private final ImmutableSet<String> additionalTargetImageTags;
    private final ContainerConfiguration containerConfiguration;
    private final Cache baseImageLayersCache;
    private final Cache applicationLayersCache;
    private Class<? extends BuildableManifestTemplate> targetFormat;
    private final boolean offline;
    private final ImmutableList<FileEntriesLayer> layerConfigurations;
    private final String toolName;
    @Nullable
    private final String toolVersion;
    private final EventHandlers eventHandlers;
    private final FailoverHttpClient httpClient;
    private final ExecutorService executorService;
    private final boolean shutDownExecutorService;
    private final boolean alwaysCacheBaseImage;
    private final ImmutableListMultimap<String, String> registryMirrors;
    private final boolean enablePlatformTags;

    public static Builder builder() {
        return new Builder();
    }

    private BuildContext(ImageConfiguration baseImageConfiguration, ImageConfiguration targetImageConfiguration, ImmutableSet<String> additionalTargetImageTags, ContainerConfiguration containerConfiguration, Cache baseImageLayersCache, Cache applicationLayersCache, Class<? extends BuildableManifestTemplate> targetFormat, boolean offline, ImmutableList<FileEntriesLayer> layerConfigurations, String toolName, @Nullable String toolVersion, EventHandlers eventHandlers, FailoverHttpClient httpClient, ExecutorService executorService, boolean shutDownExecutorService, boolean alwaysCacheBaseImage, ImmutableListMultimap<String, String> registryMirrors, boolean enablePlatformTags) {
        this.baseImageConfiguration = baseImageConfiguration;
        this.targetImageConfiguration = targetImageConfiguration;
        this.additionalTargetImageTags = additionalTargetImageTags;
        this.containerConfiguration = containerConfiguration;
        this.baseImageLayersCache = baseImageLayersCache;
        this.applicationLayersCache = applicationLayersCache;
        this.targetFormat = targetFormat;
        this.offline = offline;
        this.layerConfigurations = layerConfigurations;
        this.toolName = toolName;
        this.toolVersion = toolVersion;
        this.eventHandlers = eventHandlers;
        this.httpClient = httpClient;
        this.executorService = executorService;
        this.shutDownExecutorService = shutDownExecutorService;
        this.alwaysCacheBaseImage = alwaysCacheBaseImage;
        this.registryMirrors = registryMirrors;
        this.enablePlatformTags = enablePlatformTags;
    }

    public ImageConfiguration getBaseImageConfiguration() {
        return this.baseImageConfiguration;
    }

    public boolean getEnablePlatformTags() {
        return this.enablePlatformTags;
    }

    public ImageConfiguration getTargetImageConfiguration() {
        return this.targetImageConfiguration;
    }

    public ImmutableSet<String> getAllTargetImageTags() {
        ImmutableSet.Builder allTargetImageTags = ImmutableSet.builderWithExpectedSize((int)(1 + this.additionalTargetImageTags.size()));
        allTargetImageTags.add((Object)this.targetImageConfiguration.getImageQualifier());
        allTargetImageTags.addAll(this.additionalTargetImageTags);
        return allTargetImageTags.build();
    }

    public ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public Class<? extends BuildableManifestTemplate> getTargetFormat() {
        return this.targetFormat;
    }

    public String getToolName() {
        return this.toolName;
    }

    @Nullable
    public String getToolVersion() {
        return this.toolVersion;
    }

    public EventHandlers getEventHandlers() {
        return this.eventHandlers;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Cache getBaseImageLayersCache() {
        return this.baseImageLayersCache;
    }

    public Cache getApplicationLayersCache() {
        return this.applicationLayersCache;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean getAlwaysCacheBaseImage() {
        return this.alwaysCacheBaseImage;
    }

    public ImmutableList<FileEntriesLayer> getLayerConfigurations() {
        return this.layerConfigurations;
    }

    public ImmutableListMultimap<String, String> getRegistryMirrors() {
        return this.registryMirrors;
    }

    public RegistryClient.Factory newBaseImageRegistryClientFactory() {
        return this.newBaseImageRegistryClientFactory(this.baseImageConfiguration.getImageRegistry());
    }

    public RegistryClient.Factory newBaseImageRegistryClientFactory(String serverUrl) {
        return RegistryClient.factory(this.getEventHandlers(), serverUrl, this.baseImageConfiguration.getImageRepository(), this.httpClient).setUserAgent(this.makeUserAgent());
    }

    public RegistryClient.Factory newTargetImageRegistryClientFactory() {
        if (this.baseImageConfiguration.getImageRegistry().equals(this.targetImageConfiguration.getImageRegistry())) {
            return RegistryClient.factory(this.getEventHandlers(), this.targetImageConfiguration.getImageRegistry(), this.targetImageConfiguration.getImageRepository(), this.baseImageConfiguration.getImageRepository(), this.httpClient).setUserAgent(this.makeUserAgent());
        }
        return RegistryClient.factory(this.getEventHandlers(), this.targetImageConfiguration.getImageRegistry(), this.targetImageConfiguration.getImageRepository(), this.httpClient).setUserAgent(this.makeUserAgent());
    }

    @Override
    public void close() throws IOException {
        if (this.shutDownExecutorService) {
            this.executorService.shutdown();
        }
        this.httpClient.shutDown();
    }

    @VisibleForTesting
    String makeUserAgent() {
        if (!JibSystemProperties.isUserAgentEnabled()) {
            return "";
        }
        StringBuilder userAgentBuilder = new StringBuilder(DEFAULT_TOOL_NAME);
        userAgentBuilder.append(" ").append(this.toolVersion);
        userAgentBuilder.append(" ").append(this.toolName);
        if (!Strings.isNullOrEmpty((String)System.getProperty("_JIB_UPSTREAM_CLIENT"))) {
            userAgentBuilder.append(" ").append(System.getProperty("_JIB_UPSTREAM_CLIENT"));
        }
        return userAgentBuilder.toString();
    }

    static /* synthetic */ Class access$000() {
        return DEFAULT_TARGET_FORMAT;
    }

    public static class Builder {
        @Nullable
        private ImageConfiguration baseImageConfiguration;
        @Nullable
        private ImageConfiguration targetImageConfiguration;
        private ImmutableSet<String> additionalTargetImageTags = ImmutableSet.of();
        @Nullable
        private ContainerConfiguration containerConfiguration;
        @Nullable
        private Path applicationLayersCacheDirectory;
        @Nullable
        private Path baseImageLayersCacheDirectory;
        private boolean allowInsecureRegistries = false;
        private boolean offline = false;
        private ImmutableList<FileEntriesLayer> layerConfigurations = ImmutableList.of();
        private Class<? extends BuildableManifestTemplate> targetFormat = BuildContext.access$000();
        private String toolName = "jib";
        @Nullable
        private String toolVersion;
        private EventHandlers eventHandlers = EventHandlers.NONE;
        @Nullable
        private ExecutorService executorService;
        private boolean alwaysCacheBaseImage = false;
        private ImmutableListMultimap<String, String> registryMirrors = ImmutableListMultimap.of();
        private boolean enablePlatformTags = false;

        private Builder() {
        }

        public Builder setBaseImageConfiguration(ImageConfiguration imageConfiguration) {
            this.baseImageConfiguration = imageConfiguration;
            return this;
        }

        public Builder setTargetImageConfiguration(ImageConfiguration imageConfiguration) {
            this.targetImageConfiguration = imageConfiguration;
            return this;
        }

        public Builder setAdditionalTargetImageTags(Set<String> tags) {
            this.additionalTargetImageTags = ImmutableSet.copyOf(tags);
            return this;
        }

        public Builder setEnablePlatformTags(boolean enablePlatformTags) {
            this.enablePlatformTags = enablePlatformTags;
            return this;
        }

        public Builder setContainerConfiguration(ContainerConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
            return this;
        }

        public Builder setApplicationLayersCacheDirectory(Path applicationLayersCacheDirectory) {
            this.applicationLayersCacheDirectory = applicationLayersCacheDirectory;
            return this;
        }

        public Builder setBaseImageLayersCacheDirectory(Path baseImageLayersCacheDirectory) {
            this.baseImageLayersCacheDirectory = baseImageLayersCacheDirectory;
            return this;
        }

        public Builder setTargetFormat(ImageFormat targetFormat) {
            this.targetFormat = targetFormat == ImageFormat.Docker ? V22ManifestTemplate.class : OciManifestTemplate.class;
            return this;
        }

        public Builder setAllowInsecureRegistries(boolean allowInsecureRegistries) {
            this.allowInsecureRegistries = allowInsecureRegistries;
            return this;
        }

        public Builder setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder setAlwaysCacheBaseImage(boolean alwaysCacheBaseImage) {
            this.alwaysCacheBaseImage = alwaysCacheBaseImage;
            return this;
        }

        public Builder setLayerConfigurations(List<FileEntriesLayer> layerConfigurations) {
            this.layerConfigurations = ImmutableList.copyOf(layerConfigurations);
            return this;
        }

        public Builder setToolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public Builder setToolVersion(@Nullable String toolVersion) {
            this.toolVersion = toolVersion;
            return this;
        }

        public Builder setEventHandlers(EventHandlers eventHandlers) {
            this.eventHandlers = eventHandlers;
            return this;
        }

        public Builder setExecutorService(@Nullable ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder setRegistryMirrors(ListMultimap<String, String> registryMirrors) {
            this.registryMirrors = ImmutableListMultimap.copyOf(registryMirrors);
            return this;
        }

        public BuildContext build() throws CacheDirectoryCreationException {
            ArrayList<String> missingFields = new ArrayList<String>();
            if (this.baseImageConfiguration == null) {
                missingFields.add("base image configuration");
            }
            if (this.targetImageConfiguration == null) {
                missingFields.add("target image configuration");
            }
            if (this.containerConfiguration == null) {
                missingFields.add("container configuration");
            }
            if (this.baseImageLayersCacheDirectory == null) {
                missingFields.add("base image layers cache directory");
            }
            if (this.applicationLayersCacheDirectory == null) {
                missingFields.add("application layers cache directory");
            }
            switch (missingFields.size()) {
                case 0: {
                    Preconditions.checkNotNull((Object)this.baseImageConfiguration);
                    if (!this.baseImageConfiguration.getImage().getDigest().isPresent() && !this.baseImageConfiguration.getImage().isScratch()) {
                        this.eventHandlers.dispatch(LogEvent.warn("Base image '" + this.baseImageConfiguration.getImage() + "' does not use a specific image digest - build may not be reproducible"));
                    }
                    return new BuildContext(this.baseImageConfiguration, (ImageConfiguration)Verify.verifyNotNull((Object)this.targetImageConfiguration), this.additionalTargetImageTags, (ContainerConfiguration)Verify.verifyNotNull((Object)this.containerConfiguration), Cache.withDirectory((Path)Preconditions.checkNotNull((Object)this.baseImageLayersCacheDirectory)), Cache.withDirectory((Path)Preconditions.checkNotNull((Object)this.applicationLayersCacheDirectory)), this.targetFormat, this.offline, this.layerConfigurations, this.toolName, this.toolVersion, this.eventHandlers, new FailoverHttpClient(this.allowInsecureRegistries, JibSystemProperties.sendCredentialsOverHttp(), this.eventHandlers::dispatch), this.executorService == null ? Executors.newCachedThreadPool() : this.executorService, this.executorService == null, this.alwaysCacheBaseImage, this.registryMirrors, this.enablePlatformTags);
                }
                case 1: {
                    throw new IllegalStateException((String)missingFields.get(0) + " is required but not set");
                }
                case 2: {
                    throw new IllegalStateException((String)missingFields.get(0) + " and " + (String)missingFields.get(1) + " are required but not set");
                }
            }
            missingFields.add("and " + (String)missingFields.remove(missingFields.size() - 1));
            StringJoiner errorMessage = new StringJoiner(", ", "", " are required but not set");
            for (String missingField : missingFields) {
                errorMessage.add(missingField);
            }
            throw new IllegalStateException(errorMessage.toString());
        }

        @Nullable
        @VisibleForTesting
        Path getBaseImageLayersCacheDirectory() {
            return this.baseImageLayersCacheDirectory;
        }

        @Nullable
        @VisibleForTesting
        Path getApplicationLayersCacheDirectory() {
            return this.applicationLayersCacheDirectory;
        }
    }
}

