/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.AuthParameters;
import com.google.cloud.tools.jib.gradle.CredHelperParameters;
import com.google.cloud.tools.jib.gradle.PlatformParameters;
import com.google.cloud.tools.jib.gradle.PlatformParametersSpec;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class BaseImageParameters {
    private final AuthParameters auth;
    private final Property<String> image;
    private final CredHelperParameters credHelper;
    private final PlatformParametersSpec platformParametersSpec;
    private final ListProperty<PlatformParameters> platforms;

    @Inject
    public BaseImageParameters(ObjectFactory objectFactory) {
        this.auth = (AuthParameters)objectFactory.newInstance(AuthParameters.class, new Object[]{"from.auth"});
        this.platforms = objectFactory.listProperty(PlatformParameters.class);
        this.image = objectFactory.property(String.class);
        this.platformParametersSpec = (PlatformParametersSpec)objectFactory.newInstance(PlatformParametersSpec.class, new Object[]{this.platforms});
        this.credHelper = (CredHelperParameters)objectFactory.newInstance(CredHelperParameters.class, new Object[]{"jib.from.credHelper"});
        PlatformParameters amd64Linux = new PlatformParameters();
        amd64Linux.setArchitecture("amd64");
        amd64Linux.setOs("linux");
        this.platforms.add((Object)amd64Linux);
    }

    @Nested
    @Optional
    public ListProperty<PlatformParameters> getPlatforms() {
        List parsed;
        String property = System.getProperty("jib.from.platforms");
        if (property != null && !(parsed = ConfigurationPropertyValidator.parseListProperty(property).stream().map(PlatformParameters::of).collect(Collectors.toList())).equals(this.platforms.get())) {
            this.platforms.set(parsed);
        }
        return this.platforms;
    }

    public void platforms(Action<? super PlatformParametersSpec> action) {
        this.platforms.empty();
        action.execute((Object)this.platformParametersSpec);
    }

    @Input
    @Nullable
    @Optional
    public String getImage() {
        if (System.getProperty("jib.from.image") != null) {
            return System.getProperty("jib.from.image");
        }
        return (String)this.image.getOrNull();
    }

    public void setImage(String image) {
        this.image.set((Object)image);
    }

    public void setImage(Provider<String> image) {
        this.image.set(image);
    }

    @Nested
    @Optional
    public CredHelperParameters getCredHelper() {
        return this.credHelper;
    }

    public void setCredHelper(String helper) {
        this.credHelper.setHelper(helper);
    }

    public void credHelper(Action<? super CredHelperParameters> action) {
        action.execute((Object)this.credHelper);
    }

    @Nested
    @Optional
    public AuthParameters getAuth() {
        return this.auth;
    }

    public void auth(Action<? super AuthParameters> action) {
        action.execute((Object)this.auth);
    }
}

