/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.ImageTarball;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;

public class WriteTarFileStep
implements Callable<BuildResult> {
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final Path outputPath;
    private final Image builtImage;

    WriteTarFileStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Path outputPath, Image builtImage) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.outputPath = outputPath;
        this.builtImage = builtImage;
    }

    @Override
    public BuildResult call() throws IOException {
        this.buildContext.getEventHandlers().dispatch(LogEvent.progress("Building image to tar file..."));
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("writing to tar file", 1L);){
            if (this.outputPath.getParent() != null) {
                Files.createDirectories(this.outputPath.getParent(), new FileAttribute[0]);
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(this.outputPath, new OpenOption[0]));){
                new ImageTarball(this.builtImage, this.buildContext.getTargetImageConfiguration().getImage(), this.buildContext.getAllTargetImageTags()).writeTo(outputStream);
            }
            BuildResult buildResult = BuildResult.fromImage(this.builtImage, this.buildContext.getTargetFormat());
            return buildResult;
        }
    }
}

