/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.tar;

import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class TarExtractor {
    private TarExtractor() {
    }

    public static void extract(Path source, Path destination) throws IOException {
        TarExtractor.extract(source, destination, false);
    }

    public static void extract(Path source, Path destination, boolean enableReproducibleTimestamps) throws IOException {
        if (enableReproducibleTimestamps && Files.isDirectory(destination, new LinkOption[0]) && destination.toFile().list().length != 0) {
            throw new IllegalStateException("Cannot enable reproducible timestamps. They can only be enabled when the target root doesn't exist or is an empty directory");
        }
        String canonicalDestination = destination.toFile().getCanonicalPath();
        ArrayList<TarArchiveEntry> entries = new ArrayList<TarArchiveEntry>();
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry entry = tarArchiveInputStream.getNextTarEntry();
            while (entry != null) {
                entries.add(entry);
                Path entryPath = destination.resolve(entry.getName());
                String canonicalTarget = entryPath.toFile().getCanonicalPath();
                if (!canonicalTarget.startsWith(canonicalDestination + File.separator)) {
                    String offender = entry.getName() + " from " + source;
                    throw new IOException("Blocked unzipping files outside destination: " + offender);
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    if (entryPath.getParent() != null) {
                        Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    }
                    if (entry.isSymbolicLink()) {
                        Files.createSymbolicLink(entryPath, Paths.get(entry.getLinkName(), new String[0]), new FileAttribute[0]);
                    } else {
                        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(entryPath, new OpenOption[0]));){
                            ByteStreams.copy((InputStream)tarArchiveInputStream, (OutputStream)out);
                        }
                    }
                }
                entry = tarArchiveInputStream.getNextTarEntry();
            }
        }
        TarExtractor.preserveModificationTimes(destination, entries, enableReproducibleTimestamps);
    }

    private static void preserveModificationTimes(Path destination, List<TarArchiveEntry> entries, boolean enableReproducibleTimestamps) throws IOException {
        if (enableReproducibleTimestamps) {
            FileTime epochPlusOne = FileTime.fromMillis(1000L);
            new DirectoryWalker(destination).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).walk(path -> Files.setLastModifiedTime(path, epochPlusOne));
        }
        for (TarArchiveEntry entry : entries) {
            if (entry.isSymbolicLink()) continue;
            Files.setLastModifiedTime(destination.resolve(entry.getName()), FileTime.from(entry.getModTime().toInstant()));
        }
    }
}

