/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public class CredHelperParameters
implements RawConfiguration.CredHelperConfiguration {
    private final String propertyName;
    private final MapProperty<String, String> environment;
    @Nullable
    private String helper;

    @Inject
    public CredHelperParameters(ObjectFactory objectFactory, String propertyName) {
        this.propertyName = propertyName;
        this.environment = objectFactory.mapProperty(String.class, String.class).empty();
    }

    @Input
    @Nullable
    @org.gradle.api.tasks.Optional
    public String getHelper() {
        if (System.getProperty(this.propertyName) != null) {
            return System.getProperty(this.propertyName);
        }
        return this.helper;
    }

    @Override
    @Internal
    public Optional<String> getHelperName() {
        return Optional.ofNullable(this.getHelper());
    }

    public void setHelper(String helper) {
        this.helper = helper;
    }

    @Override
    @Input
    @org.gradle.api.tasks.Optional
    public Map<String, String> getEnvironment() {
        return (Map)this.environment.get();
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment.set(environment);
    }

    public void setEnvironment(Provider<Map<String, String>> environment) {
        this.environment.set(environment);
    }
}

