/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.RelativeUnixPath;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class JavaContainerBuilder {
    public static final String DEFAULT_APP_ROOT = "/app";
    public static final String DEFAULT_WEB_APP_ROOT = "/jetty/webapps/ROOT";
    private final JibContainerBuilder jibContainerBuilder;
    private final List<String> jvmFlags = new ArrayList<String>();
    private final LinkedHashSet<LayerType> classpathOrder = new LinkedHashSet(4);
    private final List<PathPredicatePair> addedResources = new ArrayList<PathPredicatePair>();
    private final List<PathPredicatePair> addedClasses = new ArrayList<PathPredicatePair>();
    private final List<Path> addedDependencies = new ArrayList<Path>();
    private final List<Path> addedSnapshotDependencies = new ArrayList<Path>();
    private final List<Path> addedProjectDependencies = new ArrayList<Path>();
    private final List<Path> addedOthers = new ArrayList<Path>();
    private AbsoluteUnixPath appRoot = AbsoluteUnixPath.get("/app");
    private RelativeUnixPath classesDestination = RelativeUnixPath.get("classes");
    private RelativeUnixPath resourcesDestination = RelativeUnixPath.get("resources");
    private RelativeUnixPath dependenciesDestination = RelativeUnixPath.get("libs");
    private RelativeUnixPath othersDestination = RelativeUnixPath.get("classpath");
    @Nullable
    private String mainClass;
    private BiFunction<Path, AbsoluteUnixPath, Instant> modificationTimeProvider = FileEntriesLayer.DEFAULT_MODIFICATION_TIME_PROVIDER;

    public static JavaContainerBuilder fromDistroless() {
        try {
            return JavaContainerBuilder.from(RegistryImage.named("gcr.io/distroless/java"));
        }
        catch (InvalidImageReferenceException ignored) {
            throw new IllegalStateException("Unreachable");
        }
    }

    public static JavaContainerBuilder fromDistrolessJetty() {
        try {
            return JavaContainerBuilder.from(RegistryImage.named("gcr.io/distroless/java/jetty")).setAppRoot(AbsoluteUnixPath.get(DEFAULT_WEB_APP_ROOT));
        }
        catch (InvalidImageReferenceException ignored) {
            throw new IllegalStateException("Unreachable");
        }
    }

    public static JavaContainerBuilder from(String baseImageReference) throws InvalidImageReferenceException {
        return new JavaContainerBuilder(Jib.from(baseImageReference));
    }

    public static JavaContainerBuilder from(ImageReference baseImageReference) {
        return JavaContainerBuilder.from(RegistryImage.named(baseImageReference));
    }

    public static JavaContainerBuilder from(RegistryImage registryImage) {
        return new JavaContainerBuilder(Jib.from(registryImage));
    }

    public static JavaContainerBuilder from(DockerDaemonImage dockerDaemonImage) {
        return new JavaContainerBuilder(Jib.from(dockerDaemonImage));
    }

    public static JavaContainerBuilder from(TarImage tarImage) {
        return new JavaContainerBuilder(Jib.from(tarImage));
    }

    private JavaContainerBuilder(JibContainerBuilder jibContainerBuilder) {
        this.jibContainerBuilder = jibContainerBuilder;
    }

    public JavaContainerBuilder setAppRoot(String appRoot) {
        return this.setAppRoot(AbsoluteUnixPath.get(appRoot));
    }

    public JavaContainerBuilder setAppRoot(AbsoluteUnixPath appRoot) {
        this.appRoot = appRoot;
        return this;
    }

    public JavaContainerBuilder setClassesDestination(RelativeUnixPath classesDestination) {
        this.classesDestination = classesDestination;
        return this;
    }

    public JavaContainerBuilder setResourcesDestination(RelativeUnixPath resourcesDestination) {
        this.resourcesDestination = resourcesDestination;
        return this;
    }

    public JavaContainerBuilder setDependenciesDestination(RelativeUnixPath dependenciesDestination) {
        this.dependenciesDestination = dependenciesDestination;
        return this;
    }

    public JavaContainerBuilder setOthersDestination(RelativeUnixPath othersDestination) {
        this.othersDestination = othersDestination;
        return this;
    }

    public JavaContainerBuilder addDependencies(List<Path> dependencyFiles) throws IOException {
        for (Path file : dependencyFiles) {
            if (Files.exists(file, new LinkOption[0])) continue;
            throw new NoSuchFileException(file.toString());
        }
        this.addedDependencies.addAll(dependencyFiles);
        this.classpathOrder.add(LayerType.DEPENDENCIES);
        return this;
    }

    public JavaContainerBuilder addDependencies(Path ... dependencyFiles) throws IOException {
        return this.addDependencies(Arrays.asList(dependencyFiles));
    }

    public JavaContainerBuilder addSnapshotDependencies(List<Path> dependencyFiles) throws IOException {
        for (Path file : dependencyFiles) {
            if (Files.exists(file, new LinkOption[0])) continue;
            throw new NoSuchFileException(file.toString());
        }
        this.addedSnapshotDependencies.addAll(dependencyFiles);
        this.classpathOrder.add(LayerType.DEPENDENCIES);
        return this;
    }

    public JavaContainerBuilder addSnapshotDependencies(Path ... dependencyFiles) throws IOException {
        return this.addSnapshotDependencies(Arrays.asList(dependencyFiles));
    }

    public JavaContainerBuilder addProjectDependencies(List<Path> dependencyFiles) throws IOException {
        for (Path file : dependencyFiles) {
            if (Files.exists(file, new LinkOption[0])) continue;
            throw new NoSuchFileException(file.toString());
        }
        this.addedProjectDependencies.addAll(dependencyFiles);
        this.classpathOrder.add(LayerType.DEPENDENCIES);
        return this;
    }

    public JavaContainerBuilder addProjectDependencies(Path ... dependencyFiles) throws IOException {
        return this.addProjectDependencies(Arrays.asList(dependencyFiles));
    }

    public JavaContainerBuilder addResources(Path resourceFilesDirectory) throws IOException {
        return this.addResources(resourceFilesDirectory, path -> true);
    }

    public JavaContainerBuilder addResources(Path resourceFilesDirectory, Predicate<Path> pathFilter) throws IOException {
        this.classpathOrder.add(LayerType.RESOURCES);
        return this.addDirectory(this.addedResources, resourceFilesDirectory, pathFilter);
    }

    public JavaContainerBuilder addClasses(Path classFilesDirectory) throws IOException {
        return this.addClasses(classFilesDirectory, path -> true);
    }

    public JavaContainerBuilder addClasses(Path classFilesDirectory, Predicate<Path> pathFilter) throws IOException {
        this.classpathOrder.add(LayerType.CLASSES);
        return this.addDirectory(this.addedClasses, classFilesDirectory, pathFilter);
    }

    public JavaContainerBuilder addToClasspath(List<Path> otherFiles) throws IOException {
        for (Path file : otherFiles) {
            if (Files.exists(file, new LinkOption[0])) continue;
            throw new NoSuchFileException(file.toString());
        }
        this.classpathOrder.add(LayerType.EXTRA_FILES);
        this.addedOthers.addAll(otherFiles);
        return this;
    }

    public JavaContainerBuilder addToClasspath(Path ... otherFiles) throws IOException {
        return this.addToClasspath(Arrays.asList(otherFiles));
    }

    public JavaContainerBuilder addJvmFlag(String jvmFlag) {
        this.jvmFlags.add(jvmFlag);
        return this;
    }

    public JavaContainerBuilder addJvmFlags(List<String> jvmFlags) {
        this.jvmFlags.addAll(jvmFlags);
        return this;
    }

    public JavaContainerBuilder addJvmFlags(String ... jvmFlags) {
        this.jvmFlags.addAll(Arrays.asList(jvmFlags));
        return this;
    }

    public JavaContainerBuilder setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public JavaContainerBuilder setModificationTimeProvider(BiFunction<Path, AbsoluteUnixPath, Instant> modificationTimeProvider) {
        this.modificationTimeProvider = modificationTimeProvider;
        return this;
    }

    public JibContainerBuilder toContainerBuilder() throws IOException {
        if (this.mainClass == null && !this.jvmFlags.isEmpty()) {
            throw new IllegalStateException("Failed to construct entrypoint on JavaContainerBuilder; jvmFlags were set, but mainClass is null. Specify the main class using JavaContainerBuilder#setMainClass(String), or consider using MainClassFinder to infer the main class.");
        }
        if (this.classpathOrder.isEmpty()) {
            throw new IllegalStateException("Failed to construct entrypoint because no files were added to the JavaContainerBuilder");
        }
        EnumMap<LayerType, FileEntriesLayer.Builder> layerBuilders = new EnumMap<LayerType, FileEntriesLayer.Builder>(LayerType.class);
        for (PathPredicatePair directory : this.addedClasses) {
            this.addDirectoryContentsToLayer(layerBuilders, LayerType.CLASSES, directory.path, directory.predicate, this.appRoot.resolve(this.classesDestination));
        }
        for (PathPredicatePair directory : this.addedResources) {
            this.addDirectoryContentsToLayer(layerBuilders, LayerType.RESOURCES, directory.path, directory.predicate, this.appRoot.resolve(this.resourcesDestination));
        }
        List duplicates = Streams.concat((Stream[])new Stream[]{this.addedDependencies.stream(), this.addedSnapshotDependencies.stream(), this.addedProjectDependencies.stream()}).map(Path::getFileName).map(Path::toString).collect(Collectors.groupingBy(filename -> filename, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        ImmutableMap layerMap = ImmutableMap.of((Object)((Object)LayerType.DEPENDENCIES), this.addedDependencies, (Object)((Object)LayerType.SNAPSHOT_DEPENDENCIES), this.addedSnapshotDependencies, (Object)((Object)LayerType.PROJECT_DEPENDENCIES), this.addedProjectDependencies);
        for (LayerType layerType : layerMap.keySet()) {
            for (Path file : (List)Preconditions.checkNotNull((Object)((List)layerMap.get((Object)layerType)))) {
                String jarName = file.getFileName().toString();
                if (duplicates.contains(jarName)) {
                    jarName = jarName.replaceFirst("\\.jar$", "-" + Files.size(file)) + ".jar";
                }
                this.addFileToLayer(layerBuilders, layerType, file, this.appRoot.resolve(this.dependenciesDestination).resolve(jarName));
            }
        }
        for (Path path : this.addedOthers) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.addDirectoryContentsToLayer(layerBuilders, LayerType.EXTRA_FILES, path, ignored -> true, this.appRoot.resolve(this.othersDestination));
                continue;
            }
            this.addFileToLayer(layerBuilders, LayerType.EXTRA_FILES, path, this.appRoot.resolve(this.othersDestination).resolve(path.getFileName()));
        }
        ArrayList<FileEntriesLayer> layers = new ArrayList<FileEntriesLayer>();
        layerBuilders.forEach((type, builder) -> layers.add(builder.setName(type.getName()).build()));
        this.jibContainerBuilder.setFileEntriesLayers(layers);
        if (this.mainClass != null) {
            ArrayList<String> classpathElements = new ArrayList<String>();
            block11: for (LayerType path : this.classpathOrder) {
                switch (path) {
                    case CLASSES: {
                        classpathElements.add(this.appRoot.resolve(this.classesDestination).toString());
                        continue block11;
                    }
                    case RESOURCES: {
                        classpathElements.add(this.appRoot.resolve(this.resourcesDestination).toString());
                        continue block11;
                    }
                    case DEPENDENCIES: {
                        classpathElements.add(this.appRoot.resolve(this.dependenciesDestination).resolve("*").toString());
                        continue block11;
                    }
                    case EXTRA_FILES: {
                        classpathElements.add(this.appRoot.resolve(this.othersDestination).toString());
                        continue block11;
                    }
                }
                throw new RuntimeException("Bug in jib-core; please report the bug at https://github.com/GoogleContainerTools/jib/issues/new");
            }
            String classpathString = String.join((CharSequence)":", classpathElements);
            ArrayList<String> entrypoint = new ArrayList<String>(4 + this.jvmFlags.size());
            entrypoint.add("java");
            entrypoint.addAll(this.jvmFlags);
            entrypoint.add("-cp");
            entrypoint.add(classpathString);
            entrypoint.add(this.mainClass);
            this.jibContainerBuilder.setEntrypoint(entrypoint);
        }
        return this.jibContainerBuilder;
    }

    private JavaContainerBuilder addDirectory(List<PathPredicatePair> addedPaths, Path directory, Predicate<Path> filter) throws NoSuchFileException, NotDirectoryException {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new NoSuchFileException(directory.toString());
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new NotDirectoryException(directory.toString());
        }
        addedPaths.add(new PathPredicatePair(directory, filter));
        return this;
    }

    private void addFileToLayer(Map<LayerType, FileEntriesLayer.Builder> layerBuilders, LayerType layerType, Path sourceFile, AbsoluteUnixPath pathInContainer) {
        if (!layerBuilders.containsKey((Object)layerType)) {
            layerBuilders.put(layerType, FileEntriesLayer.builder());
        }
        Instant modificationTime = this.modificationTimeProvider.apply(sourceFile, pathInContainer);
        layerBuilders.get((Object)layerType).addEntry(sourceFile, pathInContainer, modificationTime);
    }

    private void addDirectoryContentsToLayer(Map<LayerType, FileEntriesLayer.Builder> layerBuilders, LayerType layerType, Path sourceRoot, Predicate<Path> pathFilter, AbsoluteUnixPath basePathInContainer) throws IOException {
        if (!layerBuilders.containsKey((Object)layerType)) {
            layerBuilders.put(layerType, FileEntriesLayer.builder());
        }
        FileEntriesLayer.Builder builder = layerBuilders.get((Object)layerType);
        new DirectoryWalker(sourceRoot).filterRoot().filter(path -> Files.isDirectory(path, new LinkOption[0]) || pathFilter.test((Path)path)).walk(path -> {
            AbsoluteUnixPath pathOnContainer = basePathInContainer.resolve(sourceRoot.relativize(path));
            Instant modificationTime = this.modificationTimeProvider.apply(path, pathOnContainer);
            builder.addEntry(path, pathOnContainer, modificationTime);
        });
    }

    @VisibleForTesting
    public static enum LayerType {
        DEPENDENCIES("dependencies"),
        SNAPSHOT_DEPENDENCIES("snapshot dependencies"),
        PROJECT_DEPENDENCIES("project dependencies"),
        RESOURCES("resources"),
        CLASSES("classes"),
        EXTRA_FILES("extra files");

        private final String name;

        private LayerType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class PathPredicatePair {
        private final Path path;
        private final Predicate<Path> predicate;

        private PathPredicatePair(Path path, Predicate<Path> predicate) {
            this.path = path;
            this.predicate = predicate;
        }
    }
}

