/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.cloudsdk;

import com.google.cloud.tools.appengine.operations.Gcloud;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkNotFoundException;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkOutOfDateException;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkVersionFileException;
import com.google.cloud.tools.appengine.operations.cloudsdk.process.ProcessHandlerException;
import java.io.IOException;

public class ConfigReader {
    public static final String APPENGINE_CONFIG = "APPENGINE_CONFIG";
    public static final String GCLOUD_CONFIG = "GCLOUD_CONFIG";
    private final Gcloud gcloud;

    ConfigReader(Gcloud gcloud) {
        this.gcloud = gcloud;
    }

    public String getProjectId() {
        try {
            String gcloudProject = this.gcloud.getConfig().getProject();
            if (gcloudProject == null || gcloudProject.trim().isEmpty()) {
                throw new RuntimeException("Project was not found in gcloud config");
            }
            return gcloudProject;
        }
        catch (CloudSdkNotFoundException | CloudSdkOutOfDateException | CloudSdkVersionFileException | ProcessHandlerException | IOException ex) {
            throw new RuntimeException("Failed to read project from gcloud config", ex);
        }
    }
}

