/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.deploy;

import com.google.cloud.tools.maven.cloudsdk.ConfigReader;
import com.google.common.annotations.VisibleForTesting;

public class ConfigProcessor {
    private final ConfigReader configReader;
    @VisibleForTesting
    static final String PROJECT_ERROR = "Deployment projectId must be configured on the appengine-maven-plugin using <deploy.projectId> or by setting the system property 'app.deploy.projectId'\n1. Set projectId = my-project-id\n2. Set projectId = GCLOUD_CONFIG to use project from your gcloud configuration\n3. Using projectId = APPENGINE_CONFIG has been deprecated.";
    @VisibleForTesting
    static final String VERSION_ERROR = "Deployment version must be configured on the appengine-maven-plugin using <deploy.version> or by setting the system property 'app.deploy.version'\n1. Set version = my-version\n2. Set version = GCLOUD_CONFIG to have gcloud generate a version for you\n3. Using version = APPENGINE_CONFIG has been deprecated";

    public ConfigProcessor(ConfigReader configReader) {
        this.configReader = configReader;
    }

    public String processProjectId(String projectId) {
        if (projectId == null || projectId.trim().isEmpty() || projectId.equals("APPENGINE_CONFIG")) {
            throw new IllegalArgumentException(PROJECT_ERROR);
        }
        if (projectId.equals("GCLOUD_CONFIG")) {
            return this.configReader.getProjectId();
        }
        return projectId;
    }

    String processVersion(String version) {
        if (version == null || version.trim().isEmpty() || version.equals("APPENGINE_CONFIG")) {
            throw new IllegalArgumentException(VERSION_ERROR);
        }
        if (version.equals("GCLOUD_CONFIG")) {
            return null;
        }
        return version;
    }
}

