/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.storage;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.util.Assert;

public class GoogleStorageLocation {
    private static final String GCS_URI_FORMAT = "gs://%s/%s";
    private final String bucketName;
    private final String blobName;
    private final URI uri;

    public GoogleStorageLocation(String gcsLocationUriString) {
        try {
            Assert.hasText((String)gcsLocationUriString, (String)"A Google Storage URI must not be null or empty");
            Assert.isTrue((boolean)gcsLocationUriString.startsWith("gs://"), (String)"A Google Storage URI must start with gs://");
            URI locationUri = new URI(gcsLocationUriString);
            Assert.isTrue((locationUri.getAuthority() != null ? 1 : 0) != 0, (String)("No bucket specified in the location: " + gcsLocationUriString));
            this.bucketName = locationUri.getAuthority();
            this.blobName = GoogleStorageLocation.getBlobPathFromUri(locationUri);
            if (this.blobName == null && !gcsLocationUriString.endsWith("/")) {
                locationUri = new URI(gcsLocationUriString + "/");
            }
            this.uri = locationUri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid location: " + gcsLocationUriString, e);
        }
    }

    public boolean isBucket() {
        return this.blobName == null;
    }

    public boolean isFile() {
        return this.blobName != null && !this.blobName.endsWith("/");
    }

    public boolean isFolder() {
        return this.blobName != null && this.blobName.endsWith("/");
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public URI uri() {
        return this.uri;
    }

    public String uriString() {
        String processedBlobName = this.blobName == null ? "" : this.blobName;
        return String.format(GCS_URI_FORMAT, this.bucketName, processedBlobName);
    }

    public static GoogleStorageLocation forBucket(String bucketName) {
        return new GoogleStorageLocation(String.format(GCS_URI_FORMAT, bucketName, ""));
    }

    public static GoogleStorageLocation forFile(String bucketName, String pathToFile) {
        Assert.notNull((Object)pathToFile, (String)"The path to a Google Storage file must not be null.");
        return new GoogleStorageLocation(String.format(GCS_URI_FORMAT, bucketName, pathToFile));
    }

    public static GoogleStorageLocation forFolder(String bucketName, String pathToFolder) {
        Assert.notNull((Object)pathToFolder, (String)"The path to a Google Storage folder must not be null.");
        if (!pathToFolder.endsWith("/")) {
            pathToFolder = pathToFolder + "/";
        }
        return new GoogleStorageLocation(String.format(GCS_URI_FORMAT, bucketName, pathToFolder));
    }

    public String toString() {
        return this.uriString();
    }

    private static String getBlobPathFromUri(URI gcsUri) {
        String uriPath = gcsUri.getPath();
        if (uriPath.isEmpty() || uriPath.equals("/")) {
            return null;
        }
        return uriPath.substring(1);
    }
}

