/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.support;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.pubsub.core.PubSubException;
import com.google.cloud.spring.pubsub.core.publisher.PublisherCustomizer;
import com.google.cloud.spring.pubsub.support.PubSubTopicUtils;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import com.google.pubsub.v1.TopicName;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public class DefaultPublisherFactory
implements PublisherFactory {
    private final String projectId;
    private ExecutorProvider executorProvider;
    private TransportChannelProvider channelProvider;
    private CredentialsProvider credentialsProvider;
    private HeaderProvider headerProvider;
    private RetrySettings retrySettings;
    private BatchingSettings batchingSettings;
    private Boolean enableMessageOrdering;
    private String endpoint;
    private List<PublisherCustomizer> customizers;

    public DefaultPublisherFactory(GcpProjectIdProvider projectIdProvider) {
        Assert.notNull((Object)projectIdProvider, (String)"The project ID provider can't be null.");
        this.projectId = projectIdProvider.getProjectId();
        Assert.hasText((String)this.projectId, (String)"The project ID can't be null or empty.");
    }

    public void setExecutorProvider(ExecutorProvider executorProvider) {
        this.executorProvider = executorProvider;
    }

    public void setChannelProvider(TransportChannelProvider channelProvider) {
        this.channelProvider = channelProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setHeaderProvider(HeaderProvider headerProvider) {
        this.headerProvider = headerProvider;
    }

    public void setRetrySettings(RetrySettings retrySettings) {
        this.retrySettings = retrySettings;
    }

    public void setBatchingSettings(BatchingSettings batchingSettings) {
        this.batchingSettings = batchingSettings;
    }

    public void setEnableMessageOrdering(Boolean enableMessageOrdering) {
        this.enableMessageOrdering = enableMessageOrdering;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setCustomizers(List<PublisherCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Non-null customizers expected");
        this.customizers = Collections.unmodifiableList(customizers);
    }

    @Override
    public Publisher createPublisher(String topic) {
        try {
            Publisher.Builder publisherBuilder = Publisher.newBuilder((TopicName)PubSubTopicUtils.toTopicName(topic, this.projectId));
            this.applyPublisherSettings(publisherBuilder);
            this.applyCustomizers(publisherBuilder, topic);
            return publisherBuilder.build();
        }
        catch (IOException ioe) {
            throw new PubSubException("An error creating the Google Cloud Pub/Sub publisher occurred.", ioe);
        }
    }

    void applyPublisherSettings(Publisher.Builder publisherBuilder) {
        if (this.executorProvider != null) {
            publisherBuilder.setExecutorProvider(this.executorProvider);
        }
        if (this.channelProvider != null) {
            publisherBuilder.setChannelProvider(this.channelProvider);
        }
        if (this.credentialsProvider != null) {
            publisherBuilder.setCredentialsProvider(this.credentialsProvider);
        }
        if (this.headerProvider != null) {
            publisherBuilder.setHeaderProvider(this.headerProvider);
        }
        if (this.retrySettings != null) {
            publisherBuilder.setRetrySettings(this.retrySettings);
        }
        if (this.batchingSettings != null) {
            publisherBuilder.setBatchingSettings(this.batchingSettings);
        }
        if (this.enableMessageOrdering != null) {
            publisherBuilder.setEnableMessageOrdering(this.enableMessageOrdering.booleanValue());
        }
        if (this.endpoint != null) {
            publisherBuilder.setEndpoint(this.endpoint);
        }
    }

    void applyCustomizers(Publisher.Builder publisherBuilder, String topic) {
        if (this.customizers == null) {
            return;
        }
        for (PublisherCustomizer customizer : this.customizers) {
            customizer.apply(publisherBuilder, topic);
        }
    }
}

