/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.core.health;

import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.spring.pubsub.core.health.HealthTracker;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.util.Timestamps;
import com.google.pubsub.v1.ProjectSubscriptionName;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class HealthTrackerImpl
implements HealthTracker {
    private static final int SECOND_IN_MILLIS = 1000;
    private static final long NO_MESSAGES_OVER_THRESHOLD = 0L;
    private final ProjectSubscriptionName projectSubscriptionName;
    private final MetricServiceClient metricServiceClient;
    private final String undeliveredFilter;
    private final Integer lagThreshold;
    private final Integer backlogThreshold;
    private final Integer lookUpInternal;
    private final AtomicLong processedAt = new AtomicLong(System.currentTimeMillis());

    public HealthTrackerImpl(ProjectSubscriptionName projectSubscriptionName, MetricServiceClient metricServiceClient, Integer lagThreshold, Integer backlogThreshold, Integer lookUpInterval) {
        this.projectSubscriptionName = projectSubscriptionName;
        this.metricServiceClient = metricServiceClient;
        this.undeliveredFilter = this.undeliveredFilter(projectSubscriptionName.getSubscription());
        this.lagThreshold = lagThreshold;
        this.backlogThreshold = backlogThreshold;
        this.lookUpInternal = lookUpInterval;
    }

    @Override
    public void processedMessage() {
        long newValue = System.currentTimeMillis();
        long oldValue = this.processedAt.longValue();
        while (oldValue < newValue) {
            if (this.processedAt.compareAndSet(oldValue, newValue)) {
                return;
            }
            oldValue = this.processedAt.longValue();
        }
    }

    @Override
    public ProjectSubscriptionName subscription() {
        return this.projectSubscriptionName;
    }

    @Override
    public long messagesOverThreshold() {
        long currentMillis = System.currentTimeMillis();
        if (this.hasNotExceedTimeThreshold(currentMillis)) {
            return 0L;
        }
        Optional<Long> messagesOpt = this.getBackLogMessages(currentMillis);
        if (!messagesOpt.isPresent()) {
            return 0L;
        }
        long messageBackLog = messagesOpt.get();
        return messageBackLog - (long)this.backlogThreshold.intValue();
    }

    private boolean hasNotExceedTimeThreshold(long currentMillis) {
        long elapsedMillis = currentMillis - this.processedAt.longValue();
        long elapsedSeconds = elapsedMillis / 1000L;
        return elapsedSeconds < (long)this.lagThreshold.intValue();
    }

    private Optional<Long> getBackLogMessages(long currentMillis) {
        TimeSeries timeSeries;
        TimeInterval timeInterval = this.timeInterval(currentMillis);
        ListTimeSeriesResponse timeSeriesResponse = (ListTimeSeriesResponse)((MetricServiceClient.ListTimeSeriesPage)this.metricServiceClient.listTimeSeries(ProjectName.of((String)this.projectSubscriptionName.getProject()), this.undeliveredFilter, timeInterval, ListTimeSeriesRequest.TimeSeriesView.FULL).getPage()).getResponse();
        if (timeSeriesResponse.getTimeSeriesCount() > 0 && (timeSeries = timeSeriesResponse.getTimeSeries(0)).getPointsCount() > 0) {
            return Optional.of(timeSeries.getPoints(0).getValue().getInt64Value());
        }
        return Optional.empty();
    }

    private TimeInterval timeInterval(long currentMillis) {
        TimeInterval timeInterval = TimeInterval.newBuilder().setStartTime(Timestamps.fromMillis((long)(currentMillis - (long)(this.lookUpInternal * 60 * 1000)))).setEndTime(Timestamps.fromMillis((long)currentMillis)).build();
        return timeInterval;
    }
}

