/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.core;

import com.google.api.gax.batching.FlowController;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.spring.pubsub.support.PubSubSubscriptionUtils;
import com.google.pubsub.v1.ProjectSubscriptionName;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PubSubConfiguration {
    public static final int DEFAULT_EXECUTOR_THREADS = 4;
    private static final Long DEFAULT_MAX_ACK_EXTENSION_PERIOD = 0L;
    private final ConcurrentHashMap<String, Subscriber> subscription = new ConcurrentHashMap();
    private final Subscriber globalSubscriber = new Subscriber();
    private final Publisher publisher = new Publisher();
    private final Health health = new Health();

    public Subscriber getSubscriber() {
        return this.globalSubscriber;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public Health getHealth() {
        return this.health;
    }

    public ConcurrentMap<String, Subscriber> getSubscription() {
        return this.subscription;
    }

    public Subscriber getSubscriber(String name, String projectId) {
        ProjectSubscriptionName fullyQualifiedName = PubSubSubscriptionUtils.toProjectSubscriptionName(name, projectId);
        String fullyQualifiedSubscriptionKey = fullyQualifiedName.toString();
        if (this.subscription.containsKey(fullyQualifiedSubscriptionKey)) {
            return this.subscription.get(fullyQualifiedSubscriptionKey);
        }
        String subscriptionName = fullyQualifiedName.getSubscription();
        String projectIdFromFullName = fullyQualifiedName.getProject();
        if (this.subscription.containsKey(subscriptionName) && projectIdFromFullName.equals(projectId)) {
            this.subscription.putIfAbsent(fullyQualifiedSubscriptionKey, this.subscription.get(subscriptionName));
            this.subscription.remove(subscriptionName);
            return this.subscription.get(fullyQualifiedSubscriptionKey);
        }
        return this.subscription.computeIfAbsent(fullyQualifiedSubscriptionKey, k -> this.globalSubscriber);
    }

    public FlowControl computeSubscriberFlowControlSettings(String subscriptionName, String projectId) {
        FlowControl flowControl = this.getSubscriber(subscriptionName, projectId).getFlowControl();
        FlowControl globalFlowControl = this.globalSubscriber.getFlowControl();
        if (flowControl.getMaxOutstandingRequestBytes() == null) {
            flowControl.setMaxOutstandingRequestBytes(globalFlowControl.getMaxOutstandingRequestBytes());
        }
        if (flowControl.getMaxOutstandingElementCount() == null) {
            flowControl.setMaxOutstandingElementCount(globalFlowControl.getMaxOutstandingElementCount());
        }
        if (flowControl.getLimitExceededBehavior() == null) {
            flowControl.setLimitExceededBehavior(globalFlowControl.getLimitExceededBehavior());
        }
        return flowControl;
    }

    public Integer computeParallelPullCount(String subscriptionName, String projectId) {
        Integer parallelPullCount = this.getSubscriber(subscriptionName, projectId).getParallelPullCount();
        return parallelPullCount != null ? parallelPullCount : this.globalSubscriber.getParallelPullCount();
    }

    public StatusCode.Code[] computeRetryableCodes(String subscriptionName, String projectId) {
        StatusCode.Code[] retryableCodes = this.getSubscriber(subscriptionName, projectId).getRetryableCodes();
        return retryableCodes != null ? retryableCodes : this.globalSubscriber.getRetryableCodes();
    }

    public Long computeMaxAckExtensionPeriod(String subscriptionName, String projectId) {
        Long maxAckExtensionPeriod = this.getSubscriber(subscriptionName, projectId).getMaxAckExtensionPeriod();
        if (maxAckExtensionPeriod != null) {
            return maxAckExtensionPeriod;
        }
        Long globalMaxAckExtensionPeriod = this.globalSubscriber.getMaxAckExtensionPeriod();
        return globalMaxAckExtensionPeriod != null ? globalMaxAckExtensionPeriod : DEFAULT_MAX_ACK_EXTENSION_PERIOD;
    }

    public String computePullEndpoint(String subscriptionName, String projectId) {
        String pullEndpoint = this.getSubscriber(subscriptionName, projectId).getPullEndpoint();
        return pullEndpoint != null ? pullEndpoint : this.globalSubscriber.getPullEndpoint();
    }

    public Retry computeSubscriberRetrySettings(String subscriptionName, String projectId) {
        Retry retry = this.getSubscriber(subscriptionName, projectId).getRetry();
        Retry globalRetry = this.globalSubscriber.getRetry();
        if (retry.getTotalTimeoutSeconds() == null) {
            retry.setTotalTimeoutSeconds(globalRetry.getTotalTimeoutSeconds());
        }
        if (retry.getInitialRetryDelaySeconds() == null) {
            retry.setInitialRetryDelaySeconds(globalRetry.getInitialRetryDelaySeconds());
        }
        if (retry.getRetryDelayMultiplier() == null) {
            retry.setRetryDelayMultiplier(globalRetry.getRetryDelayMultiplier());
        }
        if (retry.getMaxRetryDelaySeconds() == null) {
            retry.setMaxRetryDelaySeconds(globalRetry.getMaxRetryDelaySeconds());
        }
        if (retry.getMaxAttempts() == null) {
            retry.setMaxAttempts(globalRetry.getMaxAttempts());
        }
        if (retry.getJittered() == null) {
            retry.setJittered(globalRetry.getJittered());
        }
        if (retry.getInitialRpcTimeoutSeconds() == null) {
            retry.setInitialRpcTimeoutSeconds(globalRetry.getInitialRpcTimeoutSeconds());
        }
        if (retry.getRpcTimeoutMultiplier() == null) {
            retry.setRpcTimeoutMultiplier(globalRetry.getRpcTimeoutMultiplier());
        }
        if (retry.getMaxRpcTimeoutSeconds() == null) {
            retry.setMaxRpcTimeoutSeconds(globalRetry.getMaxRpcTimeoutSeconds());
        }
        return retry;
    }

    public static class Batching {
        private final FlowControl flowControl = new FlowControl();
        private Long elementCountThreshold;
        private Long requestByteThreshold;
        private Long delayThresholdSeconds;
        private Boolean enabled;

        public Long getElementCountThreshold() {
            return this.elementCountThreshold;
        }

        public void setElementCountThreshold(Long elementCountThreshold) {
            this.elementCountThreshold = elementCountThreshold;
        }

        public Long getRequestByteThreshold() {
            return this.requestByteThreshold;
        }

        public void setRequestByteThreshold(Long requestByteThreshold) {
            this.requestByteThreshold = requestByteThreshold;
        }

        public Long getDelayThresholdSeconds() {
            return this.delayThresholdSeconds;
        }

        public void setDelayThresholdSeconds(Long delayThresholdSeconds) {
            this.delayThresholdSeconds = delayThresholdSeconds;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public FlowControl getFlowControl() {
            return this.flowControl;
        }
    }

    public static class FlowControl {
        private Long maxOutstandingElementCount;
        private Long maxOutstandingRequestBytes;
        private FlowController.LimitExceededBehavior limitExceededBehavior;

        public Long getMaxOutstandingElementCount() {
            return this.maxOutstandingElementCount;
        }

        public void setMaxOutstandingElementCount(Long maxOutstandingElementCount) {
            this.maxOutstandingElementCount = maxOutstandingElementCount;
        }

        public Long getMaxOutstandingRequestBytes() {
            return this.maxOutstandingRequestBytes;
        }

        public void setMaxOutstandingRequestBytes(Long maxOutstandingRequestBytes) {
            this.maxOutstandingRequestBytes = maxOutstandingRequestBytes;
        }

        public FlowController.LimitExceededBehavior getLimitExceededBehavior() {
            return this.limitExceededBehavior;
        }

        public void setLimitExceededBehavior(FlowController.LimitExceededBehavior limitExceededBehavior) {
            this.limitExceededBehavior = limitExceededBehavior;
        }
    }

    public static class Retry {
        private Long totalTimeoutSeconds;
        private Long initialRetryDelaySeconds;
        private Double retryDelayMultiplier;
        private Long maxRetryDelaySeconds;
        private Integer maxAttempts;
        private Boolean jittered;
        private Long initialRpcTimeoutSeconds;
        private Double rpcTimeoutMultiplier;
        private Long maxRpcTimeoutSeconds;

        public Long getTotalTimeoutSeconds() {
            return this.totalTimeoutSeconds;
        }

        public void setTotalTimeoutSeconds(Long totalTimeoutSeconds) {
            this.totalTimeoutSeconds = totalTimeoutSeconds;
        }

        public Long getInitialRetryDelaySeconds() {
            return this.initialRetryDelaySeconds;
        }

        public void setInitialRetryDelaySeconds(Long initialRetryDelaySeconds) {
            this.initialRetryDelaySeconds = initialRetryDelaySeconds;
        }

        public Double getRetryDelayMultiplier() {
            return this.retryDelayMultiplier;
        }

        public void setRetryDelayMultiplier(Double retryDelayMultiplier) {
            this.retryDelayMultiplier = retryDelayMultiplier;
        }

        public Long getMaxRetryDelaySeconds() {
            return this.maxRetryDelaySeconds;
        }

        public void setMaxRetryDelaySeconds(Long maxRetryDelaySeconds) {
            this.maxRetryDelaySeconds = maxRetryDelaySeconds;
        }

        public Integer getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public Boolean getJittered() {
            return this.jittered;
        }

        public void setJittered(Boolean jittered) {
            this.jittered = jittered;
        }

        public Long getInitialRpcTimeoutSeconds() {
            return this.initialRpcTimeoutSeconds;
        }

        public void setInitialRpcTimeoutSeconds(Long initialRpcTimeoutSeconds) {
            this.initialRpcTimeoutSeconds = initialRpcTimeoutSeconds;
        }

        public Double getRpcTimeoutMultiplier() {
            return this.rpcTimeoutMultiplier;
        }

        public void setRpcTimeoutMultiplier(Double rpcTimeoutMultiplier) {
            this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
        }

        public Long getMaxRpcTimeoutSeconds() {
            return this.maxRpcTimeoutSeconds;
        }

        public void setMaxRpcTimeoutSeconds(Long maxRpcTimeoutSeconds) {
            this.maxRpcTimeoutSeconds = maxRpcTimeoutSeconds;
        }
    }

    public static class Health {
        private Integer lagThreshold;
        private Integer backlogThreshold;
        private Integer lookUpInterval = 1;
        private int executorThreads = 4;

        public Integer getLagThreshold() {
            return this.lagThreshold;
        }

        public void setLagThreshold(Integer lagThreshold) {
            this.lagThreshold = lagThreshold;
        }

        public Integer getBacklogThreshold() {
            return this.backlogThreshold;
        }

        public void setBacklogThreshold(Integer backlogThreshold) {
            this.backlogThreshold = backlogThreshold;
        }

        public Integer getLookUpInterval() {
            return this.lookUpInterval;
        }

        public void setLookUpInterval(Integer lookUpInterval) {
            this.lookUpInterval = lookUpInterval;
        }

        public int getExecutorThreads() {
            return this.executorThreads;
        }

        public void setExecutorThreads(int executorThreads) {
            this.executorThreads = executorThreads;
        }
    }

    public static class Subscriber {
        private Integer executorThreads;
        private int maxAcknowledgementThreads = 4;
        private String pullEndpoint;
        private Long maxAckExtensionPeriod;
        private Integer parallelPullCount;
        private final Retry retry = new Retry();
        private final FlowControl flowControl = new FlowControl();
        private StatusCode.Code[] retryableCodes = null;

        public Retry getRetry() {
            return this.retry;
        }

        public StatusCode.Code[] getRetryableCodes() {
            return this.retryableCodes;
        }

        public void setRetryableCodes(StatusCode.Code[] retryableCodes) {
            this.retryableCodes = retryableCodes;
        }

        public FlowControl getFlowControl() {
            return this.flowControl;
        }

        public String getPullEndpoint() {
            return this.pullEndpoint;
        }

        public void setPullEndpoint(String pullEndpoint) {
            this.pullEndpoint = pullEndpoint;
        }

        public Long getMaxAckExtensionPeriod() {
            return this.maxAckExtensionPeriod;
        }

        public void setMaxAckExtensionPeriod(Long maxAckExtensionPeriod) {
            this.maxAckExtensionPeriod = maxAckExtensionPeriod;
        }

        public Integer getParallelPullCount() {
            return this.parallelPullCount;
        }

        public void setParallelPullCount(Integer parallelPullCount) {
            this.parallelPullCount = parallelPullCount;
        }

        public Integer getExecutorThreads() {
            return this.executorThreads;
        }

        public void setExecutorThreads(int executorThreads) {
            this.executorThreads = executorThreads;
        }

        public int getMaxAcknowledgementThreads() {
            return this.maxAcknowledgementThreads;
        }

        public void setMaxAcknowledgementThreads(int maxAcknowledgementThreads) {
            this.maxAcknowledgementThreads = maxAcknowledgementThreads;
        }
    }

    public static class Publisher {
        private int executorThreads = 4;
        private final Retry retry = new Retry();
        private final Batching batching = new Batching();
        private Boolean enableMessageOrdering;
        private String endpoint;

        public Batching getBatching() {
            return this.batching;
        }

        public Retry getRetry() {
            return this.retry;
        }

        public int getExecutorThreads() {
            return this.executorThreads;
        }

        public void setExecutorThreads(int executorThreads) {
            this.executorThreads = executorThreads;
        }

        public Boolean getEnableMessageOrdering() {
            return this.enableMessageOrdering;
        }

        public void setEnableMessageOrdering(Boolean enableMessageOrdering) {
            this.enableMessageOrdering = enableMessageOrdering;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }
    }
}

