/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.bigquery.core;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryJsonDataWriter
implements AutoCloseable {
    private final JsonStreamWriter streamWriter;
    private final Phaser inflightRequestCount = new Phaser(1);
    private final Object lock = new Object();
    private final Logger logger = LoggerFactory.getLogger(BigQueryJsonDataWriter.class);
    private final BigQueryWriteClient bigQueryWriteClient;
    @GuardedBy(value="lock")
    private RuntimeException error = null;

    BigQueryJsonDataWriter(TableName parentTable, BigQueryWriteClient bigQueryWriteClient) throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        WriteStream stream = WriteStream.newBuilder().setType(WriteStream.Type.PENDING).build();
        CreateWriteStreamRequest createWriteStreamRequest = CreateWriteStreamRequest.newBuilder().setParent(parentTable.toString()).setWriteStream(stream).build();
        WriteStream writeStream = bigQueryWriteClient.createWriteStream(createWriteStreamRequest);
        this.streamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (TableSchema)writeStream.getTableSchema()).build();
        this.bigQueryWriteClient = bigQueryWriteClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(JSONArray data, long offset) throws Descriptors.DescriptorValidationException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.error != null) {
                throw this.error;
            }
        }
        ApiFuture future = this.streamWriter.append(data, offset);
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new AppendCompleteCallback(), (Executor)MoreExecutors.directExecutor());
        this.inflightRequestCount.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeWriteStream() {
        this.inflightRequestCount.arriveAndAwaitAdvance();
        Object object = this.lock;
        synchronized (object) {
            if (this.error != null) {
                throw this.error;
            }
        }
        FinalizeWriteStreamResponse finalizeResponse = this.bigQueryWriteClient.finalizeWriteStream(this.streamWriter.getStreamName());
        this.logger.info("Rows written: {}", (Object)finalizeResponse.getRowCount());
    }

    public String getStreamName() {
        return this.streamWriter.getStreamName();
    }

    @Override
    public void close() throws Exception {
        this.streamWriter.close();
    }

    class AppendCompleteCallback
    implements ApiFutureCallback<AppendRowsResponse> {
        private final Logger logger = LoggerFactory.getLogger(AppendCompleteCallback.class);

        AppendCompleteCallback() {
        }

        public void onSuccess(AppendRowsResponse response) {
            this.logger.info("Append {} success", (Object)response.getAppendResult().getOffset().getValue());
            this.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(Throwable throwable) {
            String errMsg = null;
            Object object = BigQueryJsonDataWriter.this.lock;
            synchronized (object) {
                if (BigQueryJsonDataWriter.this.error == null) {
                    Exceptions.StorageException storageException = Exceptions.toStorageException((Throwable)throwable);
                    BigQueryJsonDataWriter.this.error = (RuntimeException)(storageException != null ? storageException : new RuntimeException(throwable));
                    errMsg = BigQueryJsonDataWriter.this.error.getMessage();
                }
            }
            this.logger.warn("Error: {}", errMsg);
            this.done();
        }

        private void done() {
            BigQueryJsonDataWriter.this.inflightRequestCount.arriveAndDeregister();
        }
    }
}

