/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import brave.Span;
import brave.messaging.MessagingRequest;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubProducerRequest;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubTracing;
import com.google.pubsub.v1.PubsubMessage;

class TraceHelper {
    private final PubSubTracing pubSubTracing;

    TraceHelper(PubSubTracing pubSubTracing) {
        this.pubSubTracing = pubSubTracing;
    }

    PubsubMessage instrumentMessage(PubsubMessage originalMessage, String topic) {
        Span span;
        PubsubMessage.Builder messageBuilder = PubsubMessage.newBuilder((PubsubMessage)originalMessage);
        PubSubProducerRequest request = new PubSubProducerRequest(messageBuilder, topic);
        TraceContext maybeParent = this.pubSubTracing.tracing.currentTraceContext().get();
        if (maybeParent == null) {
            TraceContextOrSamplingFlags extracted = this.pubSubTracing.extractAndClearTraceIdHeaders(this.pubSubTracing.producerExtractor, request, messageBuilder);
            span = this.pubSubTracing.nextMessagingSpan(this.pubSubTracing.producerSampler, (MessagingRequest)request, extracted);
        } else {
            span = this.pubSubTracing.tracer.newChild(maybeParent);
        }
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).name("publish");
            if (topic != null) {
                span.tag("pubsub.topic", topic);
            }
            if (this.pubSubTracing.remoteServiceName != null) {
                span.remoteServiceName(this.pubSubTracing.remoteServiceName);
            }
            long timestamp = this.pubSubTracing.tracing.clock(span.context()).currentTimeMicroseconds();
            span.start(timestamp).finish(timestamp);
        }
        this.pubSubTracing.producerInjector.inject(span.context(), (Object)request);
        return messageBuilder.build();
    }
}

