/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.sql;

import com.google.cloud.spring.autoconfigure.sql.CloudSqlJdbcInfoProvider;
import com.google.cloud.spring.autoconfigure.sql.DatabaseType;
import com.google.cloud.spring.autoconfigure.sql.GcpCloudSqlProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultCloudSqlJdbcInfoProvider
implements CloudSqlJdbcInfoProvider {
    private final GcpCloudSqlProperties properties;
    private final DatabaseType databaseType;

    public DefaultCloudSqlJdbcInfoProvider(GcpCloudSqlProperties properties, DatabaseType databaseType) {
        this.properties = properties;
        this.databaseType = databaseType;
        Assert.hasText((String)this.properties.getDatabaseName(), (String)"A database name must be provided.");
        Assert.hasText((String)properties.getInstanceConnectionName(), (String)"An instance connection name must be provided in the format <PROJECT_ID>:<REGION>:<INSTANCE_ID>.");
    }

    @Override
    public String getJdbcDriverClass() {
        return this.databaseType.getJdbcDriverName();
    }

    @Override
    public String getJdbcUrl() {
        Object jdbcUrl = String.format(this.databaseType.getJdbcUrlTemplate(), this.properties.getDatabaseName(), this.properties.getInstanceConnectionName());
        if (StringUtils.hasText((String)this.properties.getIpTypes())) {
            jdbcUrl = (String)jdbcUrl + "&ipTypes=" + this.properties.getIpTypes();
        }
        if (this.properties.isEnableIamAuth()) {
            jdbcUrl = (String)jdbcUrl + "&enableIamAuth=true&sslmode=disable";
        }
        return jdbcUrl;
    }
}

