/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.secretmanager;

import com.google.protobuf.ByteString;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.ConfigurableEnvironment;

public class GcpSecretManagerEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        boolean isSecretManagerEnabled = Boolean.parseBoolean(environment.getProperty("spring.cloud.gcp.secretmanager.enabled", "true"));
        if (isSecretManagerEnabled) {
            environment.getConversionService().addConverter((Converter)new Converter<ByteString, String>(){

                public String convert(ByteString source) {
                    return source.toStringUtf8();
                }
            });
            environment.getConversionService().addConverter((Converter)new Converter<ByteString, byte[]>(){

                public byte[] convert(ByteString source) {
                    return source.toByteArray();
                }
            });
        }
    }
}

