/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.secretmanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.spring.autoconfigure.secretmanager.GcpSecretManagerProperties;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.secretmanager.SecretManagerTemplate;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={GcpSecretManagerProperties.class})
@ConditionalOnClass(value={SecretManagerTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.secretmanager.enabled"}, matchIfMissing=true)
public class GcpSecretManagerAutoConfiguration {
    private final GcpProjectIdProvider gcpProjectIdProvider;
    private final GcpSecretManagerProperties properties;
    private final CredentialsProvider credentialsProvider;

    public GcpSecretManagerAutoConfiguration(CredentialsProvider credentialsProvider, GcpSecretManagerProperties properties, GcpProjectIdProvider projectIdProvider) {
        this.credentialsProvider = credentialsProvider;
        this.properties = properties;
        this.gcpProjectIdProvider = properties.getProjectId() != null ? properties::getProjectId : projectIdProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerServiceClient secretManagerClient() throws IOException {
        SecretManagerServiceSettings settings = ((SecretManagerServiceSettings.Builder)((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpSecretManagerAutoConfiguration.class))).build();
        return SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerTemplate secretManagerTemplate(SecretManagerServiceClient client) {
        return new SecretManagerTemplate(client, this.gcpProjectIdProvider).setAllowDefaultSecretValue(this.properties.isAllowDefaultSecret());
    }
}

