/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.secretmanager;

import com.google.cloud.spring.autoconfigure.secretmanager.SecretManagerConfigDataResource;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.secretmanager.SecretManagerPropertySource;
import com.google.cloud.spring.secretmanager.SecretManagerTemplate;
import java.io.IOException;
import java.util.Collections;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;

public class SecretManagerConfigDataLoader
implements ConfigDataLoader<SecretManagerConfigDataResource> {
    public ConfigData load(ConfigDataLoaderContext context, SecretManagerConfigDataResource resource) throws IOException, ConfigDataResourceNotFoundException {
        SecretManagerTemplate secretManagerTemplate = (SecretManagerTemplate)context.getBootstrapContext().get(SecretManagerTemplate.class);
        GcpProjectIdProvider projectIdProvider = (GcpProjectIdProvider)context.getBootstrapContext().get(GcpProjectIdProvider.class);
        return new ConfigData(Collections.singleton(new SecretManagerPropertySource("spring-cloud-gcp-secret-manager", secretManagerTemplate, projectIdProvider)), new ConfigData.Option[0]);
    }
}

