/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.grpc.alts;

import com.google.cloud.spark.bigquery.repackaged.io.grpc.Channel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ExperimentalApi;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ServerCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Status;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.AltsChannelCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.HandshakerServiceChannel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.InternalCheckGcpEnvironment;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.internal.ObjectPool;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.internal.SharedResourcePool;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.grpc.netty.InternalNettyServerCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsServerCredentials {
    private static final Logger logger = Logger.getLogger(AltsServerCredentials.class.getName());

    private AltsServerCredentials() {
    }

    public static ServerCredentials create() {
        return AltsServerCredentials.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
    public static final class Builder {
        private ObjectPool<Channel> handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
        private boolean enableUntrustedAlts;

        public Builder enableUntrustedAltsForTesting() {
            this.enableUntrustedAlts = true;
            return this;
        }

        public Builder setHandshakerAddressForTesting(String handshakerAddress) {
            this.handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.getHandshakerChannelForTesting(handshakerAddress));
            return this;
        }

        public ServerCredentials build() {
            return InternalNettyServerCredentials.create((InternalProtocolNegotiator.ProtocolNegotiator)this.buildProtocolNegotiator());
        }

        InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator() {
            if (!InternalCheckGcpEnvironment.isOnGcp()) {
                if (this.enableUntrustedAlts) {
                    logger.log(Level.WARNING, "Untrusted ALTS mode is enabled and we cannot guarantee the trustworthiness of the ALTS handshaker service");
                } else {
                    Status status = Status.INTERNAL.withDescription("ALTS is only allowed to run on Google Cloud Platform");
                    return new AltsChannelCredentials.FailingProtocolNegotiator(status);
                }
            }
            return AltsProtocolNegotiator.serverAltsProtocolNegotiator(this.handshakerChannelPool);
        }
    }
}

