/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Data;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Strings;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.BetaApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.Table;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Annotations;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.CloneDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableConstraints;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Function;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.io.opentelemetry.api.common.Attributes;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;

public class TableInfo
implements Serializable {
    static final Function<Table, TableInfo> FROM_PB_FUNCTION = new Function<Table, TableInfo>(){

        @Override
        public TableInfo apply(Table pb) {
            return TableInfo.fromPb(pb);
        }
    };
    static final Function<TableInfo, Table> TO_PB_FUNCTION = new Function<TableInfo, Table>(){

        @Override
        public Table apply(TableInfo tableInfo) {
            return tableInfo.toPb();
        }
    };
    private static final long serialVersionUID = 609769795097719407L;
    private final String etag;
    private final String generatedId;
    private final String selfLink;
    private final TableId tableId;
    private final String friendlyName;
    private final String description;
    private final Long creationTime;
    private final Long expirationTime;
    private final Long lastModifiedTime;
    private final Long numBytes;
    private final Long numLongTermBytes;
    private final Long numTimeTravelPhysicalBytes;
    private final Long numTotalLogicalBytes;
    private final Long numActiveLogicalBytes;
    private final Long numLongTermLogicalBytes;
    private final Long numTotalPhysicalBytes;
    private final Long numActivePhysicalBytes;
    private final Long numLongTermPhysicalBytes;
    private final BigInteger numRows;
    private final TableDefinition definition;
    private final EncryptionConfiguration encryptionConfiguration;
    private final Annotations labels;
    private final Annotations resourceTags;
    private final Boolean requirePartitionFilter;
    private final String defaultCollation;
    private final CloneDefinition cloneDefinition;
    private final TableConstraints tableConstraints;

    TableInfo(BuilderImpl builder) {
        this.tableId = Preconditions.checkNotNull(builder.tableId);
        this.etag = builder.etag;
        this.generatedId = builder.generatedId;
        this.selfLink = builder.selfLink;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.numBytes = builder.numBytes;
        this.numLongTermBytes = builder.numLongTermBytes;
        this.numTimeTravelPhysicalBytes = builder.numTimeTravelPhysicalBytes;
        this.numTotalLogicalBytes = builder.numTotalLogicalBytes;
        this.numActiveLogicalBytes = builder.numActiveLogicalBytes;
        this.numLongTermLogicalBytes = builder.numLongTermLogicalBytes;
        this.numTotalPhysicalBytes = builder.numTotalPhysicalBytes;
        this.numActivePhysicalBytes = builder.numActivePhysicalBytes;
        this.numLongTermPhysicalBytes = builder.numLongTermPhysicalBytes;
        this.numRows = builder.numRows;
        this.definition = builder.definition;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.labels = builder.labels;
        this.resourceTags = builder.resourceTags;
        this.requirePartitionFilter = builder.requirePartitionFilter;
        this.defaultCollation = builder.defaultCollation;
        this.cloneDefinition = builder.cloneDefinition;
        this.tableConstraints = builder.tableConstraints;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String getFriendlyName() {
        return Data.isNull(this.friendlyName) ? null : this.friendlyName;
    }

    public String getDescription() {
        return Data.isNull(this.description) ? null : this.description;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public Long getExpirationTime() {
        return Data.isNull(this.expirationTime) ? null : this.expirationTime;
    }

    public Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public <T extends TableDefinition> T getDefinition() {
        return (T)this.definition;
    }

    public Long getNumBytes() {
        return this.numBytes;
    }

    public Long getNumLongTermBytes() {
        return this.numLongTermBytes;
    }

    public Long getNumTimeTravelPhysicalBytes() {
        return this.numTimeTravelPhysicalBytes;
    }

    public Long getNumTotalLogicalBytes() {
        return this.numTotalLogicalBytes;
    }

    public Long getNumActiveLogicalBytes() {
        return this.numActiveLogicalBytes;
    }

    public Long getNumLongTermLogicalBytes() {
        return this.numLongTermLogicalBytes;
    }

    public Long getNumTotalPhysicalBytes() {
        return this.numTotalPhysicalBytes;
    }

    public Long getNumActivePhysicalBytes() {
        return this.numActivePhysicalBytes;
    }

    public Long getNumLongTermPhysicalBytes() {
        return this.numLongTermPhysicalBytes;
    }

    public BigInteger getNumRows() {
        return this.numRows;
    }

    @BetaApi
    public Map<String, String> getLabels() {
        return this.labels.userMap();
    }

    public Map<String, String> getResourceTags() {
        return this.resourceTags.userMap();
    }

    public Boolean getRequirePartitionFilter() {
        return this.requirePartitionFilter;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public CloneDefinition getCloneDefinition() {
        return this.cloneDefinition;
    }

    public TableConstraints getTableConstraints() {
        return this.tableConstraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("tableId", this.tableId).add("etag", this.etag).add("generatedId", this.generatedId).add("selfLink", this.selfLink).add("friendlyName", this.friendlyName).add("description", this.description).add("expirationTime", this.expirationTime).add("creationTime", this.creationTime).add("lastModifiedTime", this.lastModifiedTime).add("numBytes", this.numBytes).add("numLongTermBytes", this.numLongTermBytes).add("numTimeTravelPhysicalBytes", this.numTimeTravelPhysicalBytes).add("numTotalLogicalBytes", this.numTotalLogicalBytes).add("numActiveLogicalBytes", this.numActiveLogicalBytes).add("numLongTermLogicalBytes", this.numLongTermLogicalBytes).add("numTotalPhysicalBytes", this.numTotalPhysicalBytes).add("numActivePhysicalBytes", this.numActivePhysicalBytes).add("numLongTermPhysicalBytes", this.numLongTermPhysicalBytes).add("numRows", this.numRows).add("definition", this.definition).add("encryptionConfiguration", this.encryptionConfiguration).add("labels", this.labels).add("resourceTags", this.resourceTags).add("requirePartitionFilter", this.requirePartitionFilter).add("defaultCollation", this.defaultCollation).add("cloneDefinition", this.cloneDefinition).add("tableConstraints", this.tableConstraints).toString();
    }

    public int hashCode() {
        return Objects.hash(this.tableId);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(TableInfo.class) && Objects.equals(this.toPb(), ((TableInfo)obj).toPb());
    }

    public static Builder newBuilder(TableId tableId, TableDefinition definition) {
        return new BuilderImpl().setTableId(tableId).setDefinition(definition);
    }

    public static TableInfo of(TableId tableId, TableDefinition definition) {
        return TableInfo.newBuilder(tableId, definition).build();
    }

    TableInfo setProjectId(String projectId) {
        if (Strings.isNullOrEmpty(this.getTableId().getProject())) {
            return this.toBuilder().setTableId(this.getTableId().setProjectId(projectId)).build();
        }
        return this;
    }

    Table toPb() {
        Table tablePb = this.definition.toPb();
        tablePb.setTableReference(this.tableId.toPb());
        if (this.lastModifiedTime != null) {
            tablePb.setLastModifiedTime(BigInteger.valueOf(this.lastModifiedTime));
        }
        tablePb.setCreationTime(this.creationTime);
        tablePb.setDescription(this.description);
        tablePb.setEtag(this.etag);
        tablePb.setExpirationTime(this.expirationTime);
        tablePb.setFriendlyName(this.friendlyName);
        tablePb.setId(this.generatedId);
        tablePb.setSelfLink(this.selfLink);
        if (this.encryptionConfiguration != null) {
            tablePb.setEncryptionConfiguration(this.encryptionConfiguration.toPb());
        }
        tablePb.setLabels(this.labels.toPb());
        tablePb.setResourceTags(this.resourceTags.toPb());
        tablePb.setRequirePartitionFilter(this.requirePartitionFilter);
        if (this.defaultCollation != null) {
            tablePb.setDefaultCollation(this.defaultCollation);
        }
        if (this.cloneDefinition != null) {
            tablePb.setCloneDefinition(this.cloneDefinition.toPb());
        }
        if (this.tableConstraints != null) {
            tablePb.setTableConstraints(this.tableConstraints.toPb());
        }
        return tablePb;
    }

    static TableInfo fromPb(Table tablePb) {
        return new BuilderImpl(tablePb).build();
    }

    private static String getFieldAsString(Object field) {
        return field == null ? "null" : field.toString();
    }

    protected Attributes getOtelAttributes() {
        return Attributes.builder().putAll(this.getTableId().getOtelAttributes()).put("bq.table.creation_time", TableInfo.getFieldAsString(this.getCreationTime())).put("bq.table.expiration_time", TableInfo.getFieldAsString(this.getExpirationTime())).put("bq.table.last_modified_time", TableInfo.getFieldAsString(this.getLastModifiedTime())).put("bq.table.num_bytes", TableInfo.getFieldAsString(this.getNumBytes())).put("bq.table.num_rows", TableInfo.getFieldAsString(this.getNumRows())).build();
    }

    static class BuilderImpl
    extends Builder {
        private String etag;
        private String generatedId;
        private String selfLink;
        private TableId tableId;
        private String friendlyName;
        private String description;
        private Long creationTime;
        private Long expirationTime;
        private Long lastModifiedTime;
        private Long numBytes;
        private Long numLongTermBytes;
        private Long numTimeTravelPhysicalBytes;
        private Long numTotalLogicalBytes;
        private Long numActiveLogicalBytes;
        private Long numLongTermLogicalBytes;
        private Long numTotalPhysicalBytes;
        private Long numActivePhysicalBytes;
        private Long numLongTermPhysicalBytes;
        private BigInteger numRows;
        private TableDefinition definition;
        private EncryptionConfiguration encryptionConfiguration;
        private Annotations labels = Annotations.ZERO;
        private Annotations resourceTags = Annotations.ZERO;
        private Boolean requirePartitionFilter;
        private String defaultCollation;
        private CloneDefinition cloneDefinition;
        private TableConstraints tableConstraints;

        BuilderImpl() {
        }

        BuilderImpl(TableInfo tableInfo) {
            this.etag = tableInfo.etag;
            this.generatedId = tableInfo.generatedId;
            this.selfLink = tableInfo.selfLink;
            this.tableId = tableInfo.tableId;
            this.friendlyName = tableInfo.friendlyName;
            this.description = tableInfo.description;
            this.creationTime = tableInfo.creationTime;
            this.expirationTime = tableInfo.expirationTime;
            this.lastModifiedTime = tableInfo.lastModifiedTime;
            this.numBytes = tableInfo.numBytes;
            this.numLongTermBytes = tableInfo.numLongTermBytes;
            this.numTimeTravelPhysicalBytes = tableInfo.numTimeTravelPhysicalBytes;
            this.numTotalLogicalBytes = tableInfo.numTotalLogicalBytes;
            this.numActiveLogicalBytes = tableInfo.numActiveLogicalBytes;
            this.numLongTermLogicalBytes = tableInfo.numLongTermLogicalBytes;
            this.numTotalPhysicalBytes = tableInfo.numTotalPhysicalBytes;
            this.numActivePhysicalBytes = tableInfo.numActivePhysicalBytes;
            this.numLongTermPhysicalBytes = tableInfo.numLongTermPhysicalBytes;
            this.numRows = tableInfo.numRows;
            this.definition = tableInfo.definition;
            this.encryptionConfiguration = tableInfo.encryptionConfiguration;
            this.labels = tableInfo.labels;
            this.resourceTags = tableInfo.resourceTags;
            this.requirePartitionFilter = tableInfo.requirePartitionFilter;
            this.defaultCollation = tableInfo.defaultCollation;
            this.cloneDefinition = tableInfo.cloneDefinition;
            this.tableConstraints = tableInfo.tableConstraints;
        }

        BuilderImpl(Table tablePb) {
            this.tableId = TableId.fromPb(tablePb.getTableReference());
            if (tablePb.getLastModifiedTime() != null) {
                this.setLastModifiedTime(tablePb.getLastModifiedTime().longValue());
            }
            this.description = tablePb.getDescription();
            this.expirationTime = tablePb.getExpirationTime();
            this.friendlyName = tablePb.getFriendlyName();
            this.creationTime = tablePb.getCreationTime();
            this.etag = tablePb.getEtag();
            this.generatedId = tablePb.getId();
            this.selfLink = tablePb.getSelfLink();
            this.numBytes = tablePb.getNumBytes();
            this.numLongTermBytes = tablePb.getNumLongTermBytes();
            this.numTimeTravelPhysicalBytes = tablePb.getNumTimeTravelPhysicalBytes();
            this.numTotalLogicalBytes = tablePb.getNumTotalLogicalBytes();
            this.numActiveLogicalBytes = tablePb.getNumActiveLogicalBytes();
            this.numLongTermLogicalBytes = tablePb.getNumLongTermLogicalBytes();
            this.numTotalPhysicalBytes = tablePb.getNumTotalPhysicalBytes();
            this.numActivePhysicalBytes = tablePb.getNumActivePhysicalBytes();
            this.numLongTermPhysicalBytes = tablePb.getNumLongTermPhysicalBytes();
            this.numRows = tablePb.getNumRows();
            this.definition = TableDefinition.fromPb(tablePb);
            if (tablePb.getEncryptionConfiguration() != null) {
                this.encryptionConfiguration = new EncryptionConfiguration.Builder(tablePb.getEncryptionConfiguration()).build();
            }
            this.labels = Annotations.fromPb(tablePb.getLabels());
            this.resourceTags = Annotations.fromPb(tablePb.getResourceTags());
            this.requirePartitionFilter = tablePb.getRequirePartitionFilter();
            this.defaultCollation = tablePb.getDefaultCollation();
            if (tablePb.getCloneDefinition() != null) {
                this.cloneDefinition = CloneDefinition.fromPb(tablePb.getCloneDefinition());
            }
            if (tablePb.getTableConstraints() != null) {
                this.tableConstraints = TableConstraints.fromPb(tablePb.getTableConstraints());
            }
        }

        @Override
        Builder setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = MoreObjects.firstNonNull(description, Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public Builder setExpirationTime(Long expirationTime) {
            this.expirationTime = MoreObjects.firstNonNull(expirationTime, Data.nullOf(Long.class));
            return this;
        }

        @Override
        public Builder setFriendlyName(String friendlyName) {
            this.friendlyName = MoreObjects.firstNonNull(friendlyName, Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        Builder setNumBytes(Long numBytes) {
            this.numBytes = numBytes;
            return this;
        }

        @Override
        Builder setNumLongTermBytes(Long numLongTermBytes) {
            this.numLongTermBytes = numLongTermBytes;
            return this;
        }

        @Override
        Builder setNumTimeTravelPhysicalBytes(Long numTimeTravelPhysicalBytes) {
            this.numTimeTravelPhysicalBytes = numTimeTravelPhysicalBytes;
            return this;
        }

        @Override
        Builder setNumTotalLogicalBytes(Long numTotalLogicalBytes) {
            this.numTotalLogicalBytes = numTotalLogicalBytes;
            return this;
        }

        @Override
        Builder setNumActiveLogicalBytes(Long numActiveLogicalBytes) {
            this.numActiveLogicalBytes = numActiveLogicalBytes;
            return this;
        }

        @Override
        Builder setNumLongTermLogicalBytes(Long numLongTermLogicalBytes) {
            this.numLongTermLogicalBytes = numLongTermLogicalBytes;
            return this;
        }

        @Override
        Builder setNumTotalPhysicalBytes(Long numTotalPhysicalBytes) {
            this.numTotalPhysicalBytes = numTotalPhysicalBytes;
            return this;
        }

        @Override
        Builder setNumActivePhysicalBytes(Long numActivePhysicalBytes) {
            this.numActivePhysicalBytes = numActivePhysicalBytes;
            return this;
        }

        @Override
        Builder setNumLongTermPhysicalBytes(Long numLongTermPhysicalBytes) {
            this.numLongTermPhysicalBytes = numLongTermPhysicalBytes;
            return this;
        }

        @Override
        Builder setNumRows(BigInteger numRows) {
            this.numRows = numRows;
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setTableId(TableId tableId) {
            this.tableId = Preconditions.checkNotNull(tableId);
            return this;
        }

        @Override
        public Builder setDefinition(TableDefinition definition) {
            this.definition = Preconditions.checkNotNull(definition);
            return this;
        }

        @Override
        public Builder setEncryptionConfiguration(EncryptionConfiguration configuration) {
            this.encryptionConfiguration = configuration;
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.labels = Annotations.fromUser(labels);
            return this;
        }

        @Override
        public Builder setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = Annotations.fromUser(resourceTags);
            return this;
        }

        @Override
        public Builder setRequirePartitionFilter(Boolean requirePartitionFilter) {
            this.requirePartitionFilter = requirePartitionFilter;
            return this;
        }

        @Override
        public Builder setDefaultCollation(String defaultCollation) {
            this.defaultCollation = defaultCollation;
            return this;
        }

        @Override
        public Builder setCloneDefinition(CloneDefinition cloneDefinition) {
            this.cloneDefinition = cloneDefinition;
            return this;
        }

        @Override
        public Builder setTableConstraints(TableConstraints tableConstraints) {
            this.tableConstraints = tableConstraints;
            return this;
        }

        @Override
        public TableInfo build() {
            return new TableInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder setCreationTime(Long var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setEtag(String var1);

        public abstract Builder setExpirationTime(Long var1);

        public abstract Builder setFriendlyName(String var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setLastModifiedTime(Long var1);

        abstract Builder setNumBytes(Long var1);

        abstract Builder setNumLongTermBytes(Long var1);

        abstract Builder setNumTimeTravelPhysicalBytes(Long var1);

        abstract Builder setNumTotalLogicalBytes(Long var1);

        abstract Builder setNumActiveLogicalBytes(Long var1);

        abstract Builder setNumLongTermLogicalBytes(Long var1);

        abstract Builder setNumTotalPhysicalBytes(Long var1);

        abstract Builder setNumActivePhysicalBytes(Long var1);

        abstract Builder setNumLongTermPhysicalBytes(Long var1);

        abstract Builder setNumRows(BigInteger var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setTableId(TableId var1);

        public abstract Builder setDefinition(TableDefinition var1);

        @BetaApi
        public abstract Builder setLabels(Map<String, String> var1);

        public abstract Builder setResourceTags(Map<String, String> var1);

        public abstract TableInfo build();

        public abstract Builder setEncryptionConfiguration(EncryptionConfiguration var1);

        public Builder setRequirePartitionFilter(Boolean requirePartitionFilter) {
            return this;
        }

        public abstract Builder setDefaultCollation(String var1);

        public abstract Builder setCloneDefinition(CloneDefinition var1);

        public abstract Builder setTableConstraints(TableConstraints var1);
    }
}

