/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.ApiFunction;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.ExternalDataConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.Table;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.AutoValue;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.StringEnumType;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.StringEnumValue;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.AutoValue_ExternalTableDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.AvroOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.BigtableOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.GoogleSheetsOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.ParquetOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Schema;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Function;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Strings;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class ExternalTableDefinition
extends TableDefinition {
    static final Function<ExternalDataConfiguration, ExternalTableDefinition> FROM_EXTERNAL_DATA_FUNCTION = new Function<ExternalDataConfiguration, ExternalTableDefinition>(){

        @Override
        public ExternalTableDefinition apply(ExternalDataConfiguration pb) {
            return ExternalTableDefinition.fromExternalDataConfiguration(pb);
        }
    };
    static final Function<ExternalTableDefinition, ExternalDataConfiguration> TO_EXTERNAL_DATA_FUNCTION = new Function<ExternalTableDefinition, ExternalDataConfiguration>(){

        @Override
        public ExternalDataConfiguration apply(ExternalTableDefinition tableInfo) {
            return tableInfo.toExternalDataConfigurationPb();
        }
    };
    private static final long serialVersionUID = -5951580238459622025L;

    @Nullable
    public abstract String getCompression();

    @Nullable
    public abstract String getConnectionId();

    @Nullable
    public Boolean ignoreUnknownValues() {
        return this.getIgnoreUnknownValues();
    }

    @Nullable
    public abstract Boolean getIgnoreUnknownValues();

    @Nullable
    public abstract Integer getMaxBadRecords();

    @Nullable
    public List<String> getSourceUris() {
        return this.getSourceUrisImmut();
    }

    @Nullable
    public String getFileSetSpecType() {
        return this.getFileSetSpecTypeInner();
    }

    @Nullable
    abstract String getFileSetSpecTypeInner();

    @Nullable
    public abstract ImmutableList<String> getSourceUrisImmut();

    @Nullable
    public String getObjectMetadata() {
        return this.getObjectMetadataInner();
    }

    @Nullable
    abstract String getObjectMetadataInner();

    @Nullable
    public String getMetadataCacheMode() {
        return this.getMetadataCacheModeInner();
    }

    @Nullable
    abstract String getMetadataCacheModeInner();

    @Nullable
    public String getMaxStaleness() {
        return this.getMaxStalenessInner();
    }

    @Nullable
    abstract String getMaxStalenessInner();

    @Nullable
    public <F extends FormatOptions> F getFormatOptions() {
        return (F)this.getFormatOptionsInner();
    }

    @Nullable
    abstract FormatOptions getFormatOptionsInner();

    @Nullable
    public abstract ImmutableList<String> getDecimalTargetTypes();

    @Nullable
    public abstract Boolean getAutodetect();

    @Nullable
    public abstract String getReferenceFileSchemaUri();

    @Nullable
    public HivePartitioningOptions getHivePartitioningOptions() {
        return this.getHivePartitioningOptionsInner();
    }

    @Nullable
    public abstract String getTimeZone();

    @Nullable
    public abstract String getDateFormat();

    @Nullable
    public abstract String getDatetimeFormat();

    @Nullable
    public abstract String getTimeFormat();

    @Nullable
    public abstract String getTimestampFormat();

    @Nullable
    public abstract SourceColumnMatch getSourceColumnMatch();

    @Nullable
    public abstract List<String> getNullMarkers();

    @Nullable
    abstract HivePartitioningOptions getHivePartitioningOptionsInner();

    @Override
    public abstract Builder toBuilder();

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        tablePb.setExternalDataConfiguration(this.toExternalDataConfigurationPb());
        if (this.getMaxStaleness() != null) {
            tablePb.setMaxStaleness(this.getMaxStaleness());
        }
        return tablePb;
    }

    ExternalDataConfiguration toExternalDataConfigurationPb() {
        ExternalDataConfiguration externalConfigurationPb = new ExternalDataConfiguration();
        if (this.getCompression() != null) {
            externalConfigurationPb.setCompression(this.getCompression());
        }
        if (this.getConnectionId() != null) {
            externalConfigurationPb.setConnectionId(this.getConnectionId());
        }
        if (this.ignoreUnknownValues() != null) {
            externalConfigurationPb.setIgnoreUnknownValues(this.ignoreUnknownValues());
        }
        if (this.getMaxBadRecords() != null) {
            externalConfigurationPb.setMaxBadRecords(this.getMaxBadRecords());
        }
        if (this.getSchema() != null) {
            externalConfigurationPb.setSchema(this.getSchema().toPb());
        }
        if (this.getFormatOptions() != null) {
            externalConfigurationPb.setSourceFormat(((FormatOptions)this.getFormatOptions()).getType());
        }
        if (this.getSourceUris() != null) {
            externalConfigurationPb.setSourceUris(this.getSourceUris());
        }
        if (this.getDecimalTargetTypes() != null) {
            externalConfigurationPb.setDecimalTargetTypes(this.getDecimalTargetTypes());
        }
        if (this.getFormatOptions() != null && "PARQUET".equals(((FormatOptions)this.getFormatOptions()).getType())) {
            externalConfigurationPb.setParquetOptions(((ParquetOptions)this.getFormatOptions()).toPb());
        }
        if (this.getFormatOptions() != null && "AVRO".equals(((FormatOptions)this.getFormatOptions()).getType())) {
            externalConfigurationPb.setAvroOptions(((AvroOptions)this.getFormatOptions()).toPb());
        }
        if (this.getFormatOptions() != null && "CSV".equals(((FormatOptions)this.getFormatOptions()).getType())) {
            externalConfigurationPb.setCsvOptions(((CsvOptions)this.getFormatOptions()).toPb());
        }
        if (this.getFormatOptions() != null && "GOOGLE_SHEETS".equals(((FormatOptions)this.getFormatOptions()).getType())) {
            externalConfigurationPb.setGoogleSheetsOptions(((GoogleSheetsOptions)this.getFormatOptions()).toPb());
        }
        if (this.getFormatOptions() != null && "BIGTABLE".equals(((FormatOptions)this.getFormatOptions()).getType())) {
            externalConfigurationPb.setBigtableOptions(((BigtableOptions)this.getFormatOptions()).toPb());
        }
        if (this.getAutodetect() != null) {
            externalConfigurationPb.setAutodetect(this.getAutodetect());
        }
        if (this.getReferenceFileSchemaUri() != null) {
            externalConfigurationPb.setReferenceFileSchemaUri(this.getReferenceFileSchemaUri());
        }
        if (this.getHivePartitioningOptions() != null) {
            externalConfigurationPb.setHivePartitioningOptions(this.getHivePartitioningOptions().toPb());
        }
        if (this.getFileSetSpecType() != null) {
            externalConfigurationPb.setFileSetSpecType(this.getFileSetSpecType());
        }
        if (this.getObjectMetadata() != null) {
            externalConfigurationPb.setObjectMetadata(this.getObjectMetadata());
        }
        if (this.getMetadataCacheMode() != null) {
            externalConfigurationPb.setMetadataCacheMode(this.getMetadataCacheMode());
        }
        if (this.getTimeZone() != null) {
            externalConfigurationPb.setTimeZone(this.getTimeZone());
        }
        if (this.getDateFormat() != null) {
            externalConfigurationPb.setDateFormat(this.getDateFormat());
        }
        if (this.getDatetimeFormat() != null) {
            externalConfigurationPb.setDatetimeFormat(this.getDatetimeFormat());
        }
        if (this.getTimeFormat() != null) {
            externalConfigurationPb.setTimeFormat(this.getTimeFormat());
        }
        if (this.getTimestampFormat() != null) {
            externalConfigurationPb.setTimestampFormat(this.getTimestampFormat());
        }
        if (this.getSourceColumnMatch() != null) {
            externalConfigurationPb.getCsvOptions().setSourceColumnMatch(this.getSourceColumnMatch().toString());
        }
        if (this.getNullMarkers() != null) {
            externalConfigurationPb.getCsvOptions().setNullMarkers(this.getNullMarkers());
        }
        return externalConfigurationPb;
    }

    static Builder newBuilder() {
        return new AutoValue_ExternalTableDefinition.Builder().setType(TableDefinition.Type.EXTERNAL);
    }

    public static Builder newBuilder(List<String> sourceUris, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder().setSourceUris(sourceUris).setSchema(schema).setFormatOptions(format);
    }

    public static Builder newBuilder(String sourceUri, Schema schema, FormatOptions format) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(sourceUri), "Provided sourceUri is null or empty");
        return ExternalTableDefinition.newBuilder(ImmutableList.of(sourceUri), schema, format);
    }

    public static Builder newBuilder(String sourceUri, FormatOptions format) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(sourceUri), "Provided sourceUri is null or empty");
        return ExternalTableDefinition.newBuilder().setSourceUris(ImmutableList.of(sourceUri)).setFormatOptions(format);
    }

    public static Builder newBuilder(String sourceUri) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(sourceUri), "Provided sourceUri is null or empty");
        return ExternalTableDefinition.newBuilder().setSourceUris(ImmutableList.of(sourceUri));
    }

    public static ExternalTableDefinition of(List<String> sourceUris, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder(sourceUris, schema, format).build();
    }

    public static ExternalTableDefinition of(String sourceUri, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder(sourceUri, schema, format).build();
    }

    public static ExternalTableDefinition of(String sourceUri, FormatOptions format) {
        return ExternalTableDefinition.newBuilder(sourceUri, format).build();
    }

    static ExternalTableDefinition fromPb(Table tablePb) {
        Builder builder = (Builder)ExternalTableDefinition.newBuilder().table(tablePb);
        ExternalDataConfiguration externalDataConfiguration = tablePb.getExternalDataConfiguration();
        if (externalDataConfiguration != null) {
            if (externalDataConfiguration.getSourceUris() != null) {
                builder.setSourceUris(ImmutableList.copyOf(externalDataConfiguration.getSourceUris()));
            }
            if (externalDataConfiguration.getDecimalTargetTypes() != null) {
                builder.setDecimalTargetTypes(ImmutableList.copyOf(externalDataConfiguration.getDecimalTargetTypes()));
            }
            if (externalDataConfiguration.getSourceFormat() != null) {
                builder.setFormatOptions(FormatOptions.of(externalDataConfiguration.getSourceFormat()));
            }
            builder.setCompression(externalDataConfiguration.getCompression());
            if (externalDataConfiguration.getConnectionId() != null) {
                builder.setConnectionId(externalDataConfiguration.getConnectionId());
            }
            builder.setIgnoreUnknownValues(externalDataConfiguration.getIgnoreUnknownValues());
            if (externalDataConfiguration.getAvroOptions() != null) {
                builder.setFormatOptions(AvroOptions.fromPb(externalDataConfiguration.getAvroOptions()));
            }
            if (externalDataConfiguration.getCsvOptions() != null) {
                builder.setFormatOptions(CsvOptions.fromPb(externalDataConfiguration.getCsvOptions()));
            }
            if (externalDataConfiguration.getGoogleSheetsOptions() != null) {
                builder.setFormatOptions(GoogleSheetsOptions.fromPb(externalDataConfiguration.getGoogleSheetsOptions()));
            }
            if (externalDataConfiguration.getBigtableOptions() != null) {
                builder.setFormatOptions(BigtableOptions.fromPb(externalDataConfiguration.getBigtableOptions()));
            }
            if (externalDataConfiguration.getParquetOptions() != null) {
                builder.setFormatOptions(ParquetOptions.fromPb(externalDataConfiguration.getParquetOptions()));
            }
            builder.setMaxBadRecords(externalDataConfiguration.getMaxBadRecords());
            builder.setAutodetect(externalDataConfiguration.getAutodetect());
            if (externalDataConfiguration.getHivePartitioningOptions() != null) {
                builder.setHivePartitioningOptions(HivePartitioningOptions.fromPb(externalDataConfiguration.getHivePartitioningOptions()));
            }
            if (externalDataConfiguration.getReferenceFileSchemaUri() != null) {
                builder.setReferenceFileSchemaUri(externalDataConfiguration.getReferenceFileSchemaUri());
            }
            if (externalDataConfiguration.getFileSetSpecType() != null) {
                builder.setFileSetSpecType(externalDataConfiguration.getFileSetSpecType());
            }
            if (externalDataConfiguration.getObjectMetadata() != null) {
                builder.setObjectMetadata(externalDataConfiguration.getObjectMetadata());
            }
            if (externalDataConfiguration.getMetadataCacheMode() != null) {
                builder.setMetadataCacheMode(externalDataConfiguration.getMetadataCacheMode());
            }
            if (tablePb.getMaxStaleness() != null) {
                builder.setMaxStaleness(tablePb.getMaxStaleness());
            }
            if (externalDataConfiguration.getTimeZone() != null) {
                builder.setTimeZone(externalDataConfiguration.getTimeZone());
            }
            if (externalDataConfiguration.getDateFormat() != null) {
                builder.setDateFormat(externalDataConfiguration.getDateFormat());
            }
            if (externalDataConfiguration.getDatetimeFormat() != null) {
                builder.setDatetimeFormat(externalDataConfiguration.getDatetimeFormat());
            }
            if (externalDataConfiguration.getTimeFormat() != null) {
                builder.setTimeFormat(externalDataConfiguration.getTimeFormat());
            }
            if (externalDataConfiguration.getTimestampFormat() != null) {
                builder.setTimestampFormat(externalDataConfiguration.getTimestampFormat());
            }
            if (externalDataConfiguration.getCsvOptions() != null) {
                if (externalDataConfiguration.getCsvOptions().getSourceColumnMatch() != null) {
                    builder.setSourceColumnMatch(SourceColumnMatch.valueOf(externalDataConfiguration.getCsvOptions().getSourceColumnMatch()));
                }
                if (externalDataConfiguration.getCsvOptions().getNullMarkers() != null) {
                    builder.setNullMarkers(externalDataConfiguration.getCsvOptions().getNullMarkers());
                }
            }
        }
        return builder.build();
    }

    static ExternalTableDefinition fromExternalDataConfiguration(ExternalDataConfiguration externalDataConfiguration) {
        Builder builder = ExternalTableDefinition.newBuilder();
        if (externalDataConfiguration.getSourceUris() != null) {
            builder.setSourceUris(externalDataConfiguration.getSourceUris());
        }
        if (externalDataConfiguration.getDecimalTargetTypes() != null) {
            builder.setDecimalTargetTypes(externalDataConfiguration.getDecimalTargetTypes());
        }
        if (externalDataConfiguration.getSchema() != null) {
            builder.setSchema(Schema.fromPb(externalDataConfiguration.getSchema()));
        }
        if (externalDataConfiguration.getSourceFormat() != null) {
            builder.setFormatOptions(FormatOptions.of(externalDataConfiguration.getSourceFormat()));
        }
        if (externalDataConfiguration.getCompression() != null) {
            builder.setCompression(externalDataConfiguration.getCompression());
        }
        if (externalDataConfiguration.getConnectionId() != null) {
            builder.setConnectionId(externalDataConfiguration.getConnectionId());
        }
        if (externalDataConfiguration.getIgnoreUnknownValues() != null) {
            builder.setIgnoreUnknownValues(externalDataConfiguration.getIgnoreUnknownValues());
        }
        if (externalDataConfiguration.getAvroOptions() != null) {
            builder.setFormatOptions(AvroOptions.fromPb(externalDataConfiguration.getAvroOptions()));
        }
        if (externalDataConfiguration.getCsvOptions() != null) {
            builder.setFormatOptions(CsvOptions.fromPb(externalDataConfiguration.getCsvOptions()));
        }
        if (externalDataConfiguration.getGoogleSheetsOptions() != null) {
            builder.setFormatOptions(GoogleSheetsOptions.fromPb(externalDataConfiguration.getGoogleSheetsOptions()));
        }
        if (externalDataConfiguration.getBigtableOptions() != null) {
            builder.setFormatOptions(BigtableOptions.fromPb(externalDataConfiguration.getBigtableOptions()));
        }
        if (externalDataConfiguration.getParquetOptions() != null) {
            builder.setFormatOptions(ParquetOptions.fromPb(externalDataConfiguration.getParquetOptions()));
        }
        if (externalDataConfiguration.getMaxBadRecords() != null) {
            builder.setMaxBadRecords(externalDataConfiguration.getMaxBadRecords());
        }
        if (externalDataConfiguration.getAutodetect() != null) {
            builder.setAutodetect(externalDataConfiguration.getAutodetect());
        }
        if (externalDataConfiguration.getReferenceFileSchemaUri() != null) {
            builder.setReferenceFileSchemaUri(externalDataConfiguration.getReferenceFileSchemaUri());
        }
        if (externalDataConfiguration.getHivePartitioningOptions() != null) {
            builder.setHivePartitioningOptions(HivePartitioningOptions.fromPb(externalDataConfiguration.getHivePartitioningOptions()));
        }
        if (externalDataConfiguration.getFileSetSpecType() != null) {
            builder.setFileSetSpecType(externalDataConfiguration.getFileSetSpecType());
        }
        if (externalDataConfiguration.getObjectMetadata() != null) {
            builder.setObjectMetadata(externalDataConfiguration.getObjectMetadata());
        }
        if (externalDataConfiguration.getMetadataCacheMode() != null) {
            builder.setMetadataCacheMode(externalDataConfiguration.getMetadataCacheMode());
        }
        if (externalDataConfiguration.getTimeZone() != null) {
            builder.setTimeZone(externalDataConfiguration.getTimeZone());
        }
        if (externalDataConfiguration.getDateFormat() != null) {
            builder.setDateFormat(externalDataConfiguration.getDateFormat());
        }
        if (externalDataConfiguration.getDatetimeFormat() != null) {
            builder.setDatetimeFormat(externalDataConfiguration.getDatetimeFormat());
        }
        if (externalDataConfiguration.getTimeFormat() != null) {
            builder.setTimeFormat(externalDataConfiguration.getTimeFormat());
        }
        if (externalDataConfiguration.getTimestampFormat() != null) {
            builder.setTimestampFormat(externalDataConfiguration.getTimeFormat());
        }
        if (externalDataConfiguration.getCsvOptions() != null) {
            if (externalDataConfiguration.getCsvOptions().getSourceColumnMatch() != null) {
                builder.setSourceColumnMatch(SourceColumnMatch.valueOf(externalDataConfiguration.getCsvOptions().getSourceColumnMatch()));
            }
            if (externalDataConfiguration.getCsvOptions().getNullMarkers() != null) {
                builder.setNullMarkers(externalDataConfiguration.getCsvOptions().getNullMarkers());
            }
        }
        return builder.build();
    }

    public static final class SourceColumnMatch
    extends StringEnumValue {
        private static final long serialVersionUID = 818920627219751207L;
        private static final ApiFunction<String, SourceColumnMatch> CONSTRUCTOR = new ApiFunction<String, SourceColumnMatch>(){

            @Override
            public SourceColumnMatch apply(String constant) {
                return new SourceColumnMatch(constant);
            }
        };
        private static final StringEnumType<SourceColumnMatch> type = new StringEnumType<SourceColumnMatch>(SourceColumnMatch.class, CONSTRUCTOR);
        public static final SourceColumnMatch POSITION = type.createAndRegister("POSITION");
        public static final SourceColumnMatch NAME = type.createAndRegister("NAME");

        private SourceColumnMatch(String constant) {
            super(constant);
        }

        public static SourceColumnMatch valueOfStrict(String constant) {
            return type.valueOfStrict(constant);
        }

        public static SourceColumnMatch valueOf(String constant) {
            return type.valueOf(constant);
        }

        public static SourceColumnMatch[] values() {
            return type.values();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends TableDefinition.Builder<ExternalTableDefinition, Builder> {
        public Builder setSourceUris(List<String> sourceUris) {
            return this.setSourceUrisImmut(ImmutableList.copyOf(sourceUris));
        }

        abstract Builder setFileSetSpecTypeInner(String var1);

        abstract Builder setSourceUrisImmut(ImmutableList<String> var1);

        public Builder setFileSetSpecType(String fileSetSpecType) {
            return this.setFileSetSpecTypeInner(fileSetSpecType);
        }

        public Builder setFormatOptions(FormatOptions formatOptions) {
            return this.setFormatOptionsInner(formatOptions);
        }

        public abstract Builder setDecimalTargetTypes(List<String> var1);

        abstract Builder setFormatOptionsInner(FormatOptions var1);

        public abstract Builder setMaxBadRecords(Integer var1);

        public abstract Builder setIgnoreUnknownValues(Boolean var1);

        public abstract Builder setCompression(String var1);

        public abstract Builder setConnectionId(String var1);

        public abstract Builder setAutodetect(Boolean var1);

        @Override
        public abstract Builder setType(TableDefinition.Type var1);

        @Override
        public abstract Builder setSchema(Schema var1);

        public Builder setHivePartitioningOptions(HivePartitioningOptions hivePartitioningOptions) {
            return this.setHivePartitioningOptionsInner(hivePartitioningOptions);
        }

        public abstract Builder setReferenceFileSchemaUri(String var1);

        abstract Builder setHivePartitioningOptionsInner(HivePartitioningOptions var1);

        public Builder setObjectMetadata(String objectMetadata) {
            return this.setObjectMetadataInner(objectMetadata);
        }

        abstract Builder setObjectMetadataInner(String var1);

        public Builder setMetadataCacheMode(String metadataCacheMode) {
            return this.setMetadataCacheModeInner(metadataCacheMode);
        }

        abstract Builder setMetadataCacheModeInner(String var1);

        public Builder setMaxStaleness(String maxStaleness) {
            return this.setMaxStalenessInner(maxStaleness);
        }

        abstract Builder setMaxStalenessInner(String var1);

        public abstract Builder setTimeZone(String var1);

        public abstract Builder setDateFormat(String var1);

        public abstract Builder setDatetimeFormat(String var1);

        public abstract Builder setTimeFormat(String var1);

        public abstract Builder setTimestampFormat(String var1);

        public abstract Builder setSourceColumnMatch(SourceColumnMatch var1);

        public abstract Builder setNullMarkers(List<String> var1);

        @Override
        public abstract ExternalTableDefinition build();
    }
}

