/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc.ChannelFactory;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.CallOptions;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Channel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ClientCall;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ForwardingClientCall;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ForwardingClientCallListener;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ManagedChannel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Metadata;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.MethodDescriptor;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Status;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class ChannelPool
extends ManagedChannel {
    @VisibleForTesting
    static final Logger LOG = Logger.getLogger(ChannelPool.class.getName());
    private static final Duration REFRESH_PERIOD = Duration.ofMinutes(50L);
    private final ChannelPoolSettings settings;
    private final ChannelFactory channelFactory;
    private final ScheduledExecutorService executor;
    private final Object entryWriteLock = new Object();
    @VisibleForTesting
    final AtomicReference<ImmutableList<Entry>> entries = new AtomicReference();
    private final AtomicInteger indexTicker = new AtomicInteger();
    private final String authority;

    static ChannelPool create(ChannelPoolSettings settings, ChannelFactory channelFactory) throws IOException {
        return new ChannelPool(settings, channelFactory, Executors.newSingleThreadScheduledExecutor());
    }

    @VisibleForTesting
    ChannelPool(ChannelPoolSettings settings, ChannelFactory channelFactory, ScheduledExecutorService executor) throws IOException {
        this.settings = settings;
        this.channelFactory = channelFactory;
        ImmutableList.Builder initialListBuilder = ImmutableList.builder();
        for (int i = 0; i < settings.getInitialChannelCount(); ++i) {
            initialListBuilder.add(new Entry(channelFactory.createSingleChannel()));
        }
        this.entries.set((ImmutableList<Entry>)initialListBuilder.build());
        this.authority = ((Entry)this.entries.get().get(0)).channel.authority();
        this.executor = executor;
        if (!settings.isStaticSize()) {
            executor.scheduleAtFixedRate(this::resizeSafely, ChannelPoolSettings.RESIZE_INTERVAL.getSeconds(), ChannelPoolSettings.RESIZE_INTERVAL.getSeconds(), TimeUnit.SECONDS);
        }
        if (settings.isPreemptiveRefreshEnabled()) {
            executor.scheduleAtFixedRate(this::refreshSafely, REFRESH_PERIOD.getSeconds(), REFRESH_PERIOD.getSeconds(), TimeUnit.SECONDS);
        }
    }

    @Override
    public String authority() {
        return this.authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        return this.getChannel(this.indexTicker.getAndIncrement()).newCall(methodDescriptor, callOptions);
    }

    Channel getChannel(int affinity) {
        return new AffinityChannel(affinity);
    }

    @Override
    public ManagedChannel shutdown() {
        LOG.fine("Initiating graceful shutdown due to explicit request");
        List localEntries = this.entries.get();
        for (Entry entry : localEntries) {
            entry.channel.shutdown();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        return this;
    }

    @Override
    public boolean isShutdown() {
        List localEntries = this.entries.get();
        for (Entry entry : localEntries) {
            if (entry.channel.isShutdown()) continue;
            return false;
        }
        return this.executor == null || this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        List localEntries = this.entries.get();
        for (Entry entry : localEntries) {
            if (entry.channel.isTerminated()) continue;
            return false;
        }
        return this.executor == null || this.executor.isTerminated();
    }

    @Override
    public ManagedChannel shutdownNow() {
        LOG.fine("Initiating immediate shutdown due to explicit request");
        List localEntries = this.entries.get();
        for (Entry entry : localEntries) {
            entry.channel.shutdownNow();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        return this;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        List localEntries = this.entries.get();
        for (Entry entry : localEntries) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            entry.channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.executor != null) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            this.executor.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeSafely() {
        try {
            Object object = this.entryWriteLock;
            synchronized (object) {
                this.resize();
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to resize channel pool", e);
        }
    }

    @VisibleForTesting
    void resize() {
        int maxChannels;
        List localEntries = this.entries.get();
        int actualOutstandingRpcs = localEntries.stream().mapToInt(Entry::getAndResetMaxOutstanding).sum();
        int minChannels = (int)Math.ceil((double)actualOutstandingRpcs / (double)this.settings.getMaxRpcsPerChannel());
        if (minChannels < this.settings.getMinChannelCount()) {
            minChannels = this.settings.getMinChannelCount();
        }
        if ((maxChannels = (int)Math.ceil((double)actualOutstandingRpcs / (double)this.settings.getMinRpcsPerChannel())) > this.settings.getMaxChannelCount()) {
            maxChannels = this.settings.getMaxChannelCount();
        }
        if (maxChannels < minChannels) {
            maxChannels = minChannels;
        }
        int tentativeTarget = (maxChannels + minChannels) / 2;
        int currentSize = localEntries.size();
        int delta = tentativeTarget - currentSize;
        int dampenedTarget = tentativeTarget;
        if (Math.abs(delta) > 2) {
            dampenedTarget = currentSize + (int)Math.copySign(2.0f, delta);
        }
        if (localEntries.size() < minChannels) {
            LOG.fine(String.format("Detected throughput peak of %d, expanding channel pool size: %d -> %d.", actualOutstandingRpcs, currentSize, dampenedTarget));
            this.expand(dampenedTarget);
        } else if (localEntries.size() > maxChannels) {
            LOG.fine(String.format("Detected throughput drop to %d, shrinking channel pool size: %d -> %d.", actualOutstandingRpcs, currentSize, dampenedTarget));
            this.shrink(dampenedTarget);
        }
    }

    private void shrink(int desiredSize) {
        ImmutableList<Entry> localEntries = this.entries.get();
        Preconditions.checkState(localEntries.size() >= desiredSize, "current size is already smaller than the desired");
        this.entries.set((ImmutableList<Entry>)localEntries.subList(0, desiredSize));
        List removed = localEntries.subList(desiredSize, localEntries.size());
        removed.forEach(rec$ -> ((Entry)rec$).requestShutdown());
    }

    private void expand(int desiredSize) {
        List localEntries = this.entries.get();
        Preconditions.checkState(localEntries.size() <= desiredSize, "current size is already bigger than the desired");
        ImmutableCollection.Builder newEntries = ImmutableList.builder().addAll((Iterable)localEntries);
        for (int i = 0; i < desiredSize - localEntries.size(); ++i) {
            try {
                ((ImmutableList.Builder)newEntries).add(new Entry(this.channelFactory.createSingleChannel()));
                continue;
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed to add channel", e);
            }
        }
        this.entries.set((ImmutableList<Entry>)((ImmutableList.Builder)newEntries).build());
    }

    private void refreshSafely() {
        try {
            this.refresh();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to pre-emptively refresh channnels", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalApi(value="Visible for testing")
    void refresh() {
        Object object = this.entryWriteLock;
        synchronized (object) {
            LOG.fine("Refreshing all channels");
            ArrayList<Entry> newEntries = new ArrayList<Entry>((Collection)this.entries.get());
            for (int i = 0; i < newEntries.size(); ++i) {
                try {
                    newEntries.set(i, new Entry(this.channelFactory.createSingleChannel()));
                    continue;
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to refresh channel, leaving old channel", e);
                }
            }
            ImmutableList replacedEntries = this.entries.getAndSet(ImmutableList.copyOf(newEntries));
            for (Entry e : replacedEntries) {
                if (newEntries.contains(e)) continue;
                e.requestShutdown();
            }
        }
    }

    Entry getRetainedEntry(int affinity) {
        for (int i = 0; i < 5; ++i) {
            Entry entry = this.getEntry(affinity);
            if (!entry.retain()) continue;
            return entry;
        }
        throw new IllegalStateException("Bug: failed to retain a channel");
    }

    private Entry getEntry(int affinity) {
        List localEntries = this.entries.get();
        int index = Math.abs(affinity % localEntries.size());
        return (Entry)localEntries.get(index);
    }

    static class Entry {
        private final ManagedChannel channel;
        @VisibleForTesting
        final AtomicInteger outstandingRpcs = new AtomicInteger(0);
        private final AtomicInteger maxOutstanding = new AtomicInteger();
        private final AtomicBoolean shutdownRequested = new AtomicBoolean();
        private final AtomicBoolean shutdownInitiated = new AtomicBoolean();

        private Entry(ManagedChannel channel) {
            this.channel = channel;
        }

        int getAndResetMaxOutstanding() {
            return this.maxOutstanding.getAndSet(this.outstandingRpcs.get());
        }

        private boolean retain() {
            int prevMax;
            int currentOutstanding = this.outstandingRpcs.incrementAndGet();
            if (currentOutstanding > (prevMax = this.maxOutstanding.get())) {
                this.maxOutstanding.incrementAndGet();
            }
            if (this.shutdownRequested.get()) {
                this.release();
                return false;
            }
            return true;
        }

        private void release() {
            int newCount = this.outstandingRpcs.decrementAndGet();
            if (newCount < 0) {
                LOG.log(Level.WARNING, "Bug! Reference count is negative (" + newCount + ")!");
            }
            if (this.shutdownRequested.get() && this.outstandingRpcs.get() == 0) {
                this.shutdown();
            }
        }

        private void requestShutdown() {
            this.shutdownRequested.set(true);
            if (this.outstandingRpcs.get() == 0) {
                this.shutdown();
            }
        }

        private void shutdown() {
            if (this.shutdownInitiated.compareAndSet(false, true)) {
                this.channel.shutdown();
            }
        }
    }

    private class AffinityChannel
    extends Channel {
        private final int affinity;

        public AffinityChannel(int affinity) {
            this.affinity = affinity;
        }

        @Override
        public String authority() {
            return ChannelPool.this.authority;
        }

        @Override
        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            Entry entry = ChannelPool.this.getRetainedEntry(this.affinity);
            return new ReleasingClientCall<RequestT, ResponseT>(entry.channel.newCall(methodDescriptor, callOptions), entry);
        }
    }

    static class ReleasingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        @Nullable
        private CancellationException cancellationException;
        final Entry entry;
        private final AtomicBoolean wasClosed = new AtomicBoolean();
        private final AtomicBoolean wasReleased = new AtomicBoolean();

        public ReleasingClientCall(ClientCall<ReqT, RespT> delegate, Entry entry) {
            super(delegate);
            this.entry = entry;
        }

        @Override
        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            if (this.cancellationException != null) {
                throw new IllegalStateException("Call is already cancelled", this.cancellationException);
            }
            try {
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        if (!wasClosed.compareAndSet(false, true)) {
                            LOG.log(Level.WARNING, "Call is being closed more than once. Please make sure that onClose() is not being manually called.");
                            return;
                        }
                        try {
                            super.onClose(status, trailers);
                        }
                        finally {
                            if (wasReleased.compareAndSet(false, true)) {
                                entry.release();
                            } else {
                                LOG.log(Level.WARNING, "Entry was released before the call is closed. This may be due to an exception on start of the call.");
                            }
                        }
                    }
                }, headers);
            }
            catch (Exception e) {
                if (this.wasReleased.compareAndSet(false, true)) {
                    this.entry.release();
                } else {
                    LOG.log(Level.WARNING, "The entry is already released. This indicates that onClose() has already been called previously");
                }
                throw e;
            }
        }

        @Override
        public void cancel(@Nullable String message, @Nullable Throwable cause) {
            this.cancellationException = new CancellationException(message);
            super.cancel(message, cause);
        }
    }
}

