/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.client.googleapis.auth.oauth2;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Key;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Preconditions;
import java.util.Collection;

public class GoogleAuthorizationCodeRequestUrl
extends AuthorizationCodeRequestUrl {
    @Key(value="approval_prompt")
    private String approvalPrompt;
    @Key(value="access_type")
    private String accessType;

    public GoogleAuthorizationCodeRequestUrl(String clientId, String redirectUri, Collection<String> scopes) {
        this("https://accounts.google.com/o/oauth2/auth", clientId, redirectUri, scopes);
    }

    public GoogleAuthorizationCodeRequestUrl(String authorizationServerEncodedUrl, String clientId, String redirectUri, Collection<String> scopes) {
        super(authorizationServerEncodedUrl, clientId);
        this.setRedirectUri(redirectUri);
        this.setScopes((Collection)scopes);
    }

    public GoogleAuthorizationCodeRequestUrl(GoogleClientSecrets clientSecrets, String redirectUri, Collection<String> scopes) {
        this(clientSecrets.getDetails().getClientId(), redirectUri, scopes);
    }

    public final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public GoogleAuthorizationCodeRequestUrl setApprovalPrompt(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
        return this;
    }

    public final String getAccessType() {
        return this.accessType;
    }

    public GoogleAuthorizationCodeRequestUrl setAccessType(String accessType) {
        this.accessType = accessType;
        return this;
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setResponseTypes(Collection<String> responseTypes) {
        return (GoogleAuthorizationCodeRequestUrl)super.setResponseTypes((Collection)responseTypes);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setRedirectUri(String redirectUri) {
        Preconditions.checkNotNull(redirectUri);
        return (GoogleAuthorizationCodeRequestUrl)super.setRedirectUri(redirectUri);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setScopes(Collection<String> scopes) {
        Preconditions.checkArgument(scopes.iterator().hasNext());
        return (GoogleAuthorizationCodeRequestUrl)super.setScopes((Collection)scopes);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setClientId(String clientId) {
        return (GoogleAuthorizationCodeRequestUrl)super.setClientId(clientId);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setState(String state) {
        return (GoogleAuthorizationCodeRequestUrl)super.setState(state);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl set(String fieldName, Object value) {
        return (GoogleAuthorizationCodeRequestUrl)super.set(fieldName, value);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl clone() {
        return (GoogleAuthorizationCodeRequestUrl)super.clone();
    }
}

