/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.GcpUtil;
import com.google.cloud.bigquery.connector.common.UserAgentProvider;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.spark.bigquery.repackaged.com.google.gson.JsonObject;
import java.util.Optional;
import org.apache.spark.package$;
import scala.util.Properties;

public class SparkBigQueryConnectorUserAgentProvider
implements UserAgentProvider {
    @VisibleForTesting
    static String GCP_REGION_PART = GcpUtil.getGcpZone().map(region -> " region/" + region).orElse("");
    @VisibleForTesting
    static String DATAPROC_IMAGE_PART = Optional.ofNullable(System.getenv("DATAPROC_IMAGE_VERSION")).map(image -> " dataproc-image/" + image).orElse("");
    private static String SPARK_VERSION = package$.MODULE$.SPARK_VERSION();
    private static String JAVA_VERSION = System.getProperty("java.runtime.version");
    private static String SCALA_VERSION = Properties.versionNumberString();
    static final String USER_AGENT = String.format("spark/%s java/%s scala/%s%s%s", SPARK_VERSION, JAVA_VERSION, SCALA_VERSION, GCP_REGION_PART, DATAPROC_IMAGE_PART);
    private String dataSourceVersion;
    private Optional<String> gpn;

    public SparkBigQueryConnectorUserAgentProvider(String dataSourceVersion, Optional<String> gpn) {
        this.dataSourceVersion = dataSourceVersion;
        this.gpn = gpn;
    }

    @Override
    public String getUserAgent() {
        StringBuilder userAgentBuilder = new StringBuilder();
        userAgentBuilder.append("spark-bigquery-connector/").append(SparkBigQueryUtil.CONNECTOR_VERSION);
        this.gpn.ifPresent(s2 -> userAgentBuilder.append(" (GPN:").append((String)s2).append(") "));
        userAgentBuilder.append(USER_AGENT).append(" datasource/").append(this.dataSourceVersion);
        return userAgentBuilder.toString();
    }

    @Override
    public String getConnectorInfo() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("connectorVersion", SparkBigQueryUtil.CONNECTOR_VERSION);
        jsonObject.addProperty("datasource", this.dataSourceVersion);
        jsonObject.addProperty("dataprocImage", DATAPROC_IMAGE_PART);
        jsonObject.addProperty("gcpRegion", GCP_REGION_PART);
        jsonObject.addProperty("sparkVersion", SPARK_VERSION);
        jsonObject.addProperty("javaVersion", JAVA_VERSION);
        jsonObject.addProperty("scalaVersion", SCALA_VERSION);
        this.gpn.ifPresent(s2 -> jsonObject.addProperty("GPN", (String)s2));
        return jsonObject.toString();
    }
}

