/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;

public final class BigQueryUtilScala {
    private BigQueryUtilScala() {
    }

    public static void validateScalaVersionCompatibility() {
        String runtimeScalaVersion;
        try {
            Class<?> scalaPropsClass = Class.forName("scala.util.Properties$");
            Object scalaPropsModule = scalaPropsClass.getField("MODULE$").get(null);
            runtimeScalaVersion = (String)scalaPropsClass.getMethod("versionNumberString", new Class[0]).invoke(scalaPropsModule, new Object[0]);
            runtimeScalaVersion = BigQueryUtilScala.trimVersion(runtimeScalaVersion);
        }
        catch (Exception e) {
            System.err.println("Warning: Could not determine runtime Scala version for compatibility check from Java.");
            return;
        }
        Properties buildProperties = new Properties();
        try (InputStream stream = BigQueryUtilScala.class.getResourceAsStream("/spark-bigquery-connector.properties");){
            if (stream == null) {
                throw new IllegalStateException("Could not load spark-bigquery-connector.properties");
            }
            buildProperties.load(stream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load spark-bigquery-connector.properties", e);
        }
        String connectorScalaVersion = buildProperties.getProperty("scala.binary.version");
        if (connectorScalaVersion == null) {
            throw new IllegalStateException("Property 'scala.binary.version' not found in spark-bigquery-connector.properties");
        }
        if (runtimeScalaVersion != null && !runtimeScalaVersion.equals(connectorScalaVersion)) {
            throw new IllegalStateException(String.format("This connector was made for Scala %s, it was not meant to run on Scala %s", connectorScalaVersion, runtimeScalaVersion).replace('\n', ' '));
        }
    }

    private static String trimVersion(String version) {
        return version.substring(0, version.lastIndexOf(46));
    }

    public static <T> Optional<T> toOption(Optional<T> javaOptional) {
        return javaOptional;
    }
}

