/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write;

import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.InjectorBuilder;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.write.BigQueryDataSourceWriterInsertableRelation;
import com.google.cloud.spark.bigquery.write.BigQueryDeprecatedIndirectInsertableRelation;
import com.google.cloud.spark.bigquery.write.BigQueryInsertableRelationBase;
import com.google.cloud.spark.bigquery.write.context.BigQueryDataSourceWriterModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.UUID;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.collection.immutable.Map;

public class CreatableRelationProviderHelper {
    public BaseRelation createRelation(SQLContext sqlContext, SaveMode saveMode, Map<String, String> parameters, Dataset<Row> data, java.util.Map<String, String> customDefaults) {
        ImmutableMap<String, String> properties = SparkBigQueryUtil.scalaMapToJavaMap(parameters);
        return this.createRelation(sqlContext, saveMode, (java.util.Map<String, String>)properties, data, customDefaults);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode saveMode, java.util.Map<String, String> parameters, Dataset<Row> data, java.util.Map<String, String> customDefaults) {
        BigQueryInsertableRelationBase relation = this.createBigQueryInsertableRelation(sqlContext, data, parameters, saveMode, customDefaults);
        switch (saveMode) {
            case Append: {
                relation.insert(data, false);
                break;
            }
            case Overwrite: {
                relation.insert(data, true);
                break;
            }
            case ErrorIfExists: {
                if (!relation.exists()) {
                    relation.insert(data, false);
                    break;
                }
                throw new IllegalArgumentException("SaveMode is set to ErrorIfExists and Table " + BigQueryUtil.friendlyTableName((TableId)relation.getTableId()) + "already exists. Did you want to add data to the table by setting the SaveMode to Append? Example: df.write.format.options.mode(SaveMode.Append).save()");
            }
            case Ignore: {
                if (relation.exists()) break;
                relation.insert(data, false);
            }
        }
        return relation;
    }

    @VisibleForTesting
    BigQueryInsertableRelationBase createBigQueryInsertableRelation(SQLContext sqlContext, Dataset<Row> data, java.util.Map<String, String> properties, SaveMode saveMode, java.util.Map<String, String> customDefaults) {
        Injector injector = new InjectorBuilder().withDataSourceVersion(DataSourceVersion.V1).withSpark(sqlContext.sparkSession()).withSchema(data.schema()).withOptions(properties).withCustomDefaults(customDefaults).withTableIsMandatory(true).build();
        return this.createBigQueryInsertableRelationInternal(data.schema(), saveMode, injector);
    }

    public BigQueryInsertableRelationBase createBigQueryInsertableRelation(SQLContext sqlContext, StructType schema, SaveMode saveMode, SparkBigQueryConfig config) {
        Injector injector = new InjectorBuilder().withDataSourceVersion(DataSourceVersion.V1).withSpark(sqlContext.sparkSession()).withSchema(schema).withConfig(config).withTableIsMandatory(true).build();
        return this.createBigQueryInsertableRelationInternal(schema, saveMode, injector);
    }

    public BigQueryInsertableRelationBase createBigQueryInsertableRelationFromInjector(StructType schema, SaveMode saveMode, Injector injector) {
        return this.createBigQueryInsertableRelationInternal(schema, saveMode, injector);
    }

    private BigQueryInsertableRelationBase createBigQueryInsertableRelationInternal(StructType schema, SaveMode saveMode, Injector injector) {
        SparkBigQueryConfig config = (SparkBigQueryConfig)injector.getInstance(SparkBigQueryConfig.class);
        BigQueryClient bigQueryClient = (BigQueryClient)injector.getInstance(BigQueryClient.class);
        SQLContext sqlContext = ((SparkSession)injector.getInstance(SparkSession.class)).sqlContext();
        SparkBigQueryConfig.WriteMethod writeMethod = config.getWriteMethod();
        if (writeMethod == SparkBigQueryConfig.WriteMethod.INDIRECT) {
            return new BigQueryDeprecatedIndirectInsertableRelation(bigQueryClient, sqlContext, config);
        }
        Injector writerInjector = injector.createChildInjector(new Module[]{new BigQueryDataSourceWriterModule(config, UUID.randomUUID().toString(), schema, saveMode)});
        return new BigQueryDataSourceWriterInsertableRelation(bigQueryClient, sqlContext, config, writerInjector);
    }
}

