/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.cloud.bigquery.connector.common.BigQueryMetrics;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.metrics.source.Source;

public class SparkMetricsSource
implements Source,
Serializable,
BigQueryMetrics {
    private static final long serialVersionUID = -6847838588830697961L;
    private transient MetricRegistry registry = new MetricRegistry();
    private transient Timer parseTime = new Timer();
    private transient Timer timeInSpark = new Timer();
    private transient Counter bytesRead = new Counter();
    private transient Counter rowsRead = new Counter();
    private transient Timer scanTime = new Timer();

    public SparkMetricsSource() {
        this.registry.register("parseTime", (Metric)this.parseTime);
        this.registry.register("timeInSpark", (Metric)this.timeInSpark);
        this.registry.register("bytesRead", (Metric)this.bytesRead);
        this.registry.register("rowsRead", (Metric)this.rowsRead);
        this.registry.register("scanTime", (Metric)this.scanTime);
    }

    public String sourceName() {
        return "bigquery-metrics-source";
    }

    public MetricRegistry metricRegistry() {
        return this.registry;
    }

    public void updateParseTime(long val) {
        this.parseTime.update(val, TimeUnit.MILLISECONDS);
    }

    public void updateTimeInSpark(long val) {
        this.timeInSpark.update(val, TimeUnit.MILLISECONDS);
    }

    public void incrementBytesReadCounter(long val) {
        this.bytesRead.inc(val);
    }

    public void incrementRowsReadCounter(long val) {
        this.rowsRead.inc(val);
    }

    public void updateScanTime(long val) {
        this.scanTime.update(val, TimeUnit.MILLISECONDS);
    }

    public Timer getParseTime() {
        return this.parseTime;
    }

    public Timer getTimeInSpark() {
        return this.timeInSpark;
    }

    public Timer getScanTime() {
        return this.scanTime;
    }

    public Counter getBytesRead() {
        return this.bytesRead;
    }

    public Counter getRowsRead() {
        return this.rowsRead;
    }
}

