/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.metrics;

import com.google.cloud.bigquery.connector.common.ReadSessionMetrics;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.spark.bigquery.metrics.DataOrigin;
import com.google.cloud.spark.bigquery.metrics.SparkBigQueryConnectorMetricsUtils;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkBigQueryReadSessionMetrics
extends SparkListener
implements Serializable,
ReadSessionMetrics {
    private static final String BYTES_READ = "bytesRead";
    private static final String ROWS_READ = "rowsRead";
    private static final String PARSE_TIME = "parseTime";
    private static final String SCAN_TIME = "scanTime";
    private static final long serialVersionUID = -8188694570364436143L;
    private final LongAccumulator bytesReadAccumulator;
    public final LongAccumulator rowsReadAccumulator;
    private final LongAccumulator scanTimeAccumulator;
    private final LongAccumulator parseTimeAccumulator;
    private final String sessionId;
    private final SparkSession sparkSession;
    private final long timestamp;
    private final DataFormat readDataFormat;
    private final DataOrigin dataOrigin;
    public long numReadStreams;
    private static final Logger logger = LoggerFactory.getLogger(SparkBigQueryReadSessionMetrics.class);

    private SparkBigQueryReadSessionMetrics(SparkSession sparkSession, String sessionName, long timestamp, DataFormat readDataFormat, DataOrigin dataOrigin, long numReadStreams) {
        this.sparkSession = sparkSession;
        this.sessionId = sessionName;
        this.timestamp = timestamp;
        this.readDataFormat = readDataFormat;
        this.dataOrigin = dataOrigin;
        this.numReadStreams = numReadStreams;
        this.bytesReadAccumulator = sparkSession.sparkContext().longAccumulator(SparkBigQueryConnectorMetricsUtils.getAccumulatorNameForMetric(BYTES_READ, sessionName));
        this.rowsReadAccumulator = sparkSession.sparkContext().longAccumulator(SparkBigQueryConnectorMetricsUtils.getAccumulatorNameForMetric(ROWS_READ, sessionName));
        this.scanTimeAccumulator = sparkSession.sparkContext().longAccumulator(SparkBigQueryConnectorMetricsUtils.getAccumulatorNameForMetric(SCAN_TIME, sessionName));
        this.parseTimeAccumulator = sparkSession.sparkContext().longAccumulator(SparkBigQueryConnectorMetricsUtils.getAccumulatorNameForMetric(PARSE_TIME, sessionName));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sessionId, this.bytesReadAccumulator.id(), this.rowsReadAccumulator.id(), this.parseTimeAccumulator.id(), this.scanTimeAccumulator.id()});
    }

    public boolean equals(Object o) {
        if (o instanceof SparkBigQueryReadSessionMetrics) {
            SparkBigQueryReadSessionMetrics listenerObject = (SparkBigQueryReadSessionMetrics)o;
            return listenerObject.sessionId.equals(this.sessionId) && listenerObject.bytesReadAccumulator.id() == this.bytesReadAccumulator.id() && listenerObject.rowsReadAccumulator.id() == this.rowsReadAccumulator.id() && listenerObject.scanTimeAccumulator.id() == this.scanTimeAccumulator.id() && listenerObject.parseTimeAccumulator.id() == this.parseTimeAccumulator.id();
        }
        return false;
    }

    public static SparkBigQueryReadSessionMetrics from(SparkSession sparkSession, ReadSession readSession, long timestamp, DataFormat readDataFormat, DataOrigin dataOrigin, long numReadStreams) {
        return new SparkBigQueryReadSessionMetrics(sparkSession, readSession.getName(), timestamp, readDataFormat, dataOrigin, numReadStreams);
    }

    public void incrementBytesReadAccumulator(long value) {
        this.bytesReadAccumulator.add(value);
    }

    public void incrementRowsReadAccumulator(long value) {
        this.rowsReadAccumulator.add(value);
    }

    public void incrementScanTimeAccumulator(long value) {
        this.scanTimeAccumulator.add(value);
    }

    public void incrementParseTimeAccumulator(long value) {
        this.parseTimeAccumulator.add(value);
    }

    public long getBytesRead() {
        return this.bytesReadAccumulator.value();
    }

    public long getRowsRead() {
        return this.rowsReadAccumulator.value();
    }

    public long getScanTime() {
        return this.scanTimeAccumulator.value();
    }

    public long getParseTime() {
        return this.parseTimeAccumulator.value();
    }

    public long getNumReadStreams() {
        return this.numReadStreams;
    }

    public LongAccumulator getBytesReadAccumulator() {
        return this.bytesReadAccumulator;
    }

    public LongAccumulator getRowsReadAccumulator() {
        return this.rowsReadAccumulator;
    }

    public LongAccumulator getParseTimeAccumulator() {
        return this.parseTimeAccumulator;
    }

    public LongAccumulator getScanTimeAccumulator() {
        return this.scanTimeAccumulator;
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        try {
            Class<?> eventBuilderClass = Class.forName("com.google.cloud.spark.events.SparkBigQueryConnectorReadSessionEvent$SparkBigQueryConnectorReadSessionEventBuilder");
            Object builderInstance = eventBuilderClass.getDeclaredConstructor(Long.TYPE).newInstance(this.timestamp);
            eventBuilderClass.getMethod("setBytesRead", Long.TYPE).invoke(builderInstance, this.getBytesRead());
            eventBuilderClass.getMethod("setNumberOfReadStreams", Long.TYPE).invoke(builderInstance, this.numReadStreams);
            eventBuilderClass.getMethod("setParseTimeInMs", Long.TYPE).invoke(builderInstance, this.getParseTime());
            eventBuilderClass.getMethod("setScanTimeInMs", Long.TYPE).invoke(builderInstance, this.getScanTime());
            Class<?> dataFormatEnum = Class.forName("com.google.cloud.spark.events.DataFormat");
            ?[] dataFormatEnumConstants = dataFormatEnum.getEnumConstants();
            Object generatedDataFormatEnumValue = dataFormatEnumConstants[0];
            for (Object obj : dataFormatEnumConstants) {
                Method nameMethod = obj.getClass().getMethod("name", new Class[0]);
                String name = (String)nameMethod.invoke(obj, new Object[0]);
                if (!name.equals(this.readDataFormat.toString())) continue;
                generatedDataFormatEnumValue = obj;
                break;
            }
            eventBuilderClass.getMethod("setReadDataFormat", dataFormatEnum).invoke(builderInstance, generatedDataFormatEnumValue);
            Class<?> dataOriginEnum = Class.forName("com.google.cloud.spark.events.DataOrigin");
            ?[] dataOriginEnumConstants = dataOriginEnum.getEnumConstants();
            Object generatedDataOriginEnumValue = dataOriginEnumConstants[0];
            for (Object constant : dataOriginEnumConstants) {
                Method nameMethod = constant.getClass().getMethod("name", new Class[0]);
                String name = (String)nameMethod.invoke(constant, new Object[0]);
                if (!name.equals(this.dataOrigin.toString())) continue;
                generatedDataOriginEnumValue = constant;
                break;
            }
            eventBuilderClass.getMethod("setDataOrigin", dataOriginEnum).invoke(builderInstance, generatedDataOriginEnumValue);
            Method method = eventBuilderClass.getDeclaredMethod("build", new Class[0]);
            this.sparkSession.sparkContext().listenerBus().post((SparkListenerEvent)method.invoke(builderInstance, new Object[0]));
            this.sparkSession.sparkContext().removeSparkListener((SparkListenerInterface)this);
        }
        catch (ReflectiveOperationException ex) {
            logger.debug("spark.events.SparkBigQueryConnectorReadSessionEvent library not in class path");
        }
    }
}

