/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.direct;

import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.ReadSessionCreator;
import com.google.cloud.spark.bigquery.BigQueryRelation;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkFilterUtils;
import com.google.cloud.spark.bigquery.direct.BigQueryRDDFactory;
import com.google.cloud.spark.bigquery.write.BigQueryInsertableRelationBase;
import com.google.cloud.spark.bigquery.write.CreatableRelationProviderHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.sources.PrunedScan;
import org.apache.spark.sql.sources.TableScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.reflect.ClassTag$;
import scala.runtime.AbstractFunction1;

public class DirectBigQueryRelation
extends BigQueryRelation
implements TableScan,
PrunedScan,
PrunedFilteredScan,
InsertableRelation {
    private final SparkBigQueryConfig options;
    private final TableInfo table;
    private final BigQueryClient bigQueryClient;
    private final BigQueryClientFactory bigQueryReadClientFactory;
    private final BigQueryTracerFactory bigQueryTracerFactory;
    private final SQLContext sqlContext;
    private final TableDefinition defaultTableDefinition;
    private final BigQueryRDDFactory bigQueryRDDFactory;
    private String compiledFilter = "";
    public static int emptyRowRDDsCreated = 0;
    private static final Logger log = LoggerFactory.getLogger(DirectBigQueryRelation.class);

    public DirectBigQueryRelation(SparkBigQueryConfig options, TableInfo table, BigQueryClient bigQueryClient, BigQueryClientFactory bigQueryReadClientFactory, BigQueryTracerFactory bigQueryTracerFactory, SQLContext sqlContext) {
        super(options, table, sqlContext);
        this.options = options;
        this.table = table;
        this.bigQueryClient = bigQueryClient;
        this.bigQueryReadClientFactory = bigQueryReadClientFactory;
        this.bigQueryTracerFactory = bigQueryTracerFactory;
        this.sqlContext = sqlContext;
        this.defaultTableDefinition = table.getDefinition();
        this.bigQueryRDDFactory = new BigQueryRDDFactory(bigQueryClient, bigQueryReadClientFactory, bigQueryTracerFactory, options, sqlContext);
    }

    public boolean needConversion() {
        return false;
    }

    public long sizeInBytes() {
        return this.bigQueryRDDFactory.getNumBytes(this.defaultTableDefinition);
    }

    public RDD<Row> buildScan() {
        return this.buildScan(this.schema().fieldNames());
    }

    public RDD<Row> buildScan(String[] requiredColumns) {
        return this.buildScan(requiredColumns, new Filter[0]);
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        this.compiledFilter = this.getCompiledFilter(filters);
        log.info("|Querying table {}, parameters sent from Spark:|requiredColumns=[{}],|filter=[{}]", new Object[]{this.getTableNameForLogging(), String.join((CharSequence)",", requiredColumns), this.compiledFilter});
        ReadSessionCreator readSessionCreator = new ReadSessionCreator(this.options.toReadSessionCreatorConfig(), this.bigQueryClient, this.bigQueryReadClientFactory);
        if (this.options.isOptimizedEmptyProjection() && requiredColumns.length == 0) {
            TableInfo actualTable = readSessionCreator.getActualTable(this.table, ImmutableList.copyOf((Object[])requiredColumns), BigQueryUtil.emptyIfNeeded((String)this.compiledFilter));
            return this.generateEmptyRowRDD(actualTable, readSessionCreator.isInputTableAView(this.table) ? "" : this.compiledFilter);
        }
        if (requiredColumns.length == 0) {
            log.debug("Not using optimized empty projection");
        }
        return this.bigQueryRDDFactory.createRddFromTable(this.getTableId(), readSessionCreator, requiredColumns, this.compiledFilter);
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        if (this.options.getFilter().isPresent()) {
            return filters;
        }
        log.debug("unhandledFilters: {}", (Object)Arrays.stream(filters).map(f -> f.toString()).collect(Collectors.joining(" ")));
        return (Filter[])Iterables.toArray(SparkFilterUtils.unhandledFilters(this.options.getPushAllFilters(), this.options.getReadDataFormat(), (Iterable<Filter>)ImmutableList.copyOf((Object[])filters)), Filter.class);
    }

    public BigQueryRDDFactory getBigQueryRDDFactory() {
        return this.bigQueryRDDFactory;
    }

    String getCompiledFilter(Filter[] filters) {
        if (this.options.isCombinePushedDownFilters()) {
            return SparkFilterUtils.getCompiledFilter(this.options.getPushAllFilters(), this.options.getReadDataFormat(), this.options.getFilter(), filters);
        }
        return this.options.getFilter().orElse(SparkFilterUtils.compileFilters(SparkFilterUtils.handledFilters(this.options.getPushAllFilters(), this.options.getReadDataFormat(), (Iterable<Filter>)ImmutableList.copyOf((Object[])filters))));
    }

    private RDD<?> generateEmptyRowRDD(TableInfo tableInfo, String filter) {
        ++emptyRowRDDsCreated;
        Optional<Object> optionalFilter = filter.length() == 0 ? Optional.empty() : Optional.of(filter);
        long numberOfRows = this.bigQueryClient.calculateTableSize(tableInfo, optionalFilter);
        ObjectToInternalRowConverter objectToInternalRowConverter = new ObjectToInternalRowConverter();
        log.info("Used optimized BQ count(*) path. Count: {}", (Object)numberOfRows);
        return this.sqlContext.sparkContext().range(0L, numberOfRows, 1L, this.sqlContext.sparkContext().defaultParallelism()).map((Function1)objectToInternalRowConverter, ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        SaveMode mode = overwrite ? SaveMode.Overwrite : SaveMode.Append;
        BigQueryInsertableRelationBase bigQueryInsertableRelation = new CreatableRelationProviderHelper().createBigQueryInsertableRelation(this.sqlContext, data.schema(), mode, this.options);
        bigQueryInsertableRelation.insert(data, overwrite);
    }

    static String toSqlTableReference(TableId tableId) {
        return tableId.getProject() + '.' + tableId.getDataset() + '.' + tableId.getTable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DirectBigQueryRelation that = (DirectBigQueryRelation)((Object)o);
        return this.getTableId().equals((Object)that.getTableId()) && this.schema().equals((Object)that.schema()) && this.compiledFilter.equals(that.compiledFilter);
    }

    public int hashCode() {
        return Objects.hash(this.getTableId(), this.schema(), this.compiledFilter);
    }

    public String toString() {
        return "DirectBigQueryRelation[" + this.getTableNameForLogging() + "]";
    }

    private static class ObjectToInternalRowConverter
    extends AbstractFunction1<Object, InternalRow>
    implements Serializable {
        private static final long serialVersionUID = 8504174848470344221L;

        private ObjectToInternalRowConverter() {
        }

        public InternalRow apply(Object v1) {
            return InternalRow.empty();
        }
    }
}

