/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;

public class SparkBigQueryProxyAndHttpConfig
implements BigQueryProxyConfig,
Serializable {
    public static final String PROXY_ADDRESS_OPTION = "proxyAddress";
    public static final String PROXY_USERNAME_OPTION = "proxyUsername";
    public static final String PROXY_PASSWORD_OPTION = "proxyPassword";
    public static final String HTTP_MAX_RETRY_OPTION = "httpMaxRetry";
    public static final String HTTP_CONNECT_TIMEOUT_OPTION = "httpConnectTimeout";
    public static final String HTTP_READ_TIMEOUT_OPTION = "httpReadTimeout";
    public static final String GCS_CONFIG_PROXY_ADDRESS_PROPERTY = "fs.gs.proxy.address";
    public static final String GCS_CONFIG_PROXY_USERNAME_PROPERTY = "fs.gs.proxy.username";
    public static final String GCS_CONFIG_PROXY_PASSWORD_PROPERTY = "fs.gs.proxy.password";
    public static final String GCS_CONFIG_HTTP_MAX_RETRY_PROPERTY = "fs.gs.http.max.retry";
    public static final String GCS_CONFIG_HTTP_CONNECT_TIMEOUT_PROPERTY = "fs.gs.http.connect-timeout";
    public static final String GCS_CONFIG_HTTP_READ_TIMEOUT_PROPERTY = "fs.gs.http.read-timeout";
    private static final long serialVersionUID = 1651319822547810178L;
    private com.google.common.base.Optional<URI> proxyUri;
    private com.google.common.base.Optional<String> proxyUsername;
    private com.google.common.base.Optional<String> proxyPassword;
    private com.google.common.base.Optional<Integer> httpMaxRetry;
    private com.google.common.base.Optional<Integer> httpConnectTimeout;
    private com.google.common.base.Optional<Integer> httpReadTimeout;

    @VisibleForTesting
    SparkBigQueryProxyAndHttpConfig() {
    }

    @VisibleForTesting
    public static SparkBigQueryProxyAndHttpConfig from(Map<String, String> options, ImmutableMap<String, String> globalOptions, Configuration hadoopConfiguration) throws IllegalArgumentException {
        SparkBigQueryProxyAndHttpConfig config = new SparkBigQueryProxyAndHttpConfig();
        com.google.common.base.Optional<String> proxyAddress = SparkBigQueryProxyAndHttpConfig.getProperty(options, globalOptions, hadoopConfiguration, PROXY_ADDRESS_OPTION, GCS_CONFIG_PROXY_ADDRESS_PROPERTY);
        config.proxyUri = com.google.common.base.Optional.fromNullable((Object)SparkBigQueryProxyAndHttpConfig.parseProxyAddress((String)proxyAddress.or((Object)"")));
        config.proxyUsername = SparkBigQueryProxyAndHttpConfig.getProperty(options, globalOptions, hadoopConfiguration, PROXY_USERNAME_OPTION, GCS_CONFIG_PROXY_USERNAME_PROPERTY);
        config.proxyPassword = SparkBigQueryProxyAndHttpConfig.getProperty(options, globalOptions, hadoopConfiguration, PROXY_PASSWORD_OPTION, GCS_CONFIG_PROXY_PASSWORD_PROPERTY);
        SparkBigQueryProxyAndHttpConfig.checkProxyParamsValidity(config);
        config.httpMaxRetry = SparkBigQueryProxyAndHttpConfig.getProperty(options, globalOptions, hadoopConfiguration, HTTP_MAX_RETRY_OPTION, GCS_CONFIG_HTTP_MAX_RETRY_PROPERTY).transform(Integer::valueOf);
        config.httpConnectTimeout = SparkBigQueryProxyAndHttpConfig.getProperty(options, globalOptions, hadoopConfiguration, HTTP_CONNECT_TIMEOUT_OPTION, GCS_CONFIG_HTTP_CONNECT_TIMEOUT_PROPERTY).transform(Integer::valueOf);
        config.httpReadTimeout = SparkBigQueryProxyAndHttpConfig.getProperty(options, globalOptions, hadoopConfiguration, HTTP_READ_TIMEOUT_OPTION, GCS_CONFIG_HTTP_READ_TIMEOUT_PROPERTY).transform(Integer::valueOf);
        SparkBigQueryProxyAndHttpConfig.checkHttpParamsValidity(config);
        return config;
    }

    private static void checkProxyParamsValidity(SparkBigQueryProxyAndHttpConfig config) throws IllegalArgumentException {
        if (!config.proxyUri.isPresent() && (config.proxyUsername.isPresent() || config.proxyPassword.isPresent())) {
            throw new IllegalArgumentException("Please set proxyAddress in order to use a proxy. Setting proxyUsername or proxyPassword is not enough");
        }
        BigQueryProxyTransporterBuilder.checkProxyParamsValidity(config.getProxyUsername(), config.getProxyPassword());
    }

    private static void checkHttpParamsValidity(SparkBigQueryProxyAndHttpConfig config) throws IllegalArgumentException {
        if (config.getHttpMaxRetry().isPresent() && config.getHttpMaxRetry().get() < 0) {
            throw new IllegalArgumentException("Http Max Retry value cannot be negative");
        }
    }

    private static com.google.common.base.Optional<String> getProperty(Map<String, String> options, ImmutableMap<String, String> globalOptions, Configuration hadoopConfiguration, String bqOption, String gcsProperty) {
        return com.google.common.base.Optional.fromJavaUtil((Optional)BigQueryUtil.firstPresent((Optional[])new Optional[]{SparkBigQueryProxyAndHttpConfig.getFirstOrSecondOption(options, globalOptions, bqOption).toJavaUtil(), com.google.common.base.Optional.fromNullable((Object)hadoopConfiguration.get(gcsProperty)).toJavaUtil()}));
    }

    private static com.google.common.base.Optional<String> getFirstOrSecondOption(Map<String, String> options, ImmutableMap<String, String> globalOptions, String name) {
        return com.google.common.base.Optional.fromNullable((Object)options.get(name.toLowerCase())).or(com.google.common.base.Optional.fromNullable((Object)globalOptions.get((Object)name)));
    }

    @VisibleForTesting
    static URI parseProxyAddress(String proxyAddress) {
        if (Strings.isNullOrEmpty((String)proxyAddress)) {
            return null;
        }
        String uriString = (proxyAddress.contains("//") ? "" : "//") + proxyAddress;
        try {
            URI uri = new URI(uriString);
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            Preconditions.checkArgument((Strings.isNullOrEmpty((String)scheme) || scheme.matches("https?") ? 1 : 0) != 0, (String)"Proxy address '%s' has invalid scheme '%s'.", (Object)proxyAddress, (Object)scheme);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)host) ? 1 : 0) != 0, (String)"Proxy address '%s' has no host.", (Object)proxyAddress);
            Preconditions.checkArgument((port != -1 ? 1 : 0) != 0, (String)"Proxy address '%s' has no port.", (Object)proxyAddress);
            Preconditions.checkArgument((boolean)uri.equals(new URI(scheme, null, host, port, null, null, null)), (String)"Invalid proxy address '%s'.", (Object)proxyAddress);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid proxy address '%s'.", proxyAddress), e);
        }
    }

    public Optional<URI> getProxyUri() {
        return this.proxyUri.toJavaUtil();
    }

    public Optional<String> getProxyUsername() {
        return this.proxyUsername.toJavaUtil();
    }

    public Optional<String> getProxyPassword() {
        return this.proxyPassword.toJavaUtil();
    }

    Optional<Integer> getHttpMaxRetry() {
        return this.httpMaxRetry.toJavaUtil();
    }

    Optional<Integer> getHttpConnectTimeout() {
        return this.httpConnectTimeout.toJavaUtil();
    }

    Optional<Integer> getHttpReadTimeout() {
        return this.httpReadTimeout.toJavaUtil();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SparkBigQueryProxyAndHttpConfig)) {
            return false;
        }
        SparkBigQueryProxyAndHttpConfig that = (SparkBigQueryProxyAndHttpConfig)o;
        return Objects.equal(this.proxyUri, that.proxyUri) && Objects.equal(this.proxyUsername, that.proxyUsername) && Objects.equal(this.proxyPassword, that.proxyPassword) && Objects.equal(this.httpMaxRetry, that.httpMaxRetry) && Objects.equal(this.httpConnectTimeout, that.httpConnectTimeout) && Objects.equal(this.httpReadTimeout, that.httpReadTimeout);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proxyUri, this.proxyUsername, this.proxyPassword, this.httpMaxRetry, this.httpConnectTimeout, this.httpReadTimeout});
    }
}

