/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.spark.bigquery.SupportedCustomDataType;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public abstract class ArrowSchemaConverter
extends ColumnVector {
    public abstract ValueVector vector();

    public boolean hasNull() {
        return this.vector().getNullCount() > 0;
    }

    public int numNulls() {
        return this.vector().getNullCount();
    }

    public void close() {
        this.vector().close();
    }

    public boolean getBoolean(int rowId) {
        throw new UnsupportedOperationException();
    }

    public byte getByte(int rowId) {
        throw new UnsupportedOperationException();
    }

    public short getShort(int rowId) {
        throw new UnsupportedOperationException();
    }

    public int getInt(int rowId) {
        throw new UnsupportedOperationException();
    }

    public long getLong(int rowId) {
        throw new UnsupportedOperationException();
    }

    public float getFloat(int rowId) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int rowId) {
        throw new UnsupportedOperationException();
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        throw new UnsupportedOperationException();
    }

    public UTF8String getUTF8String(int rowId) {
        throw new UnsupportedOperationException();
    }

    public byte[] getBinary(int rowId) {
        throw new UnsupportedOperationException();
    }

    public ColumnarArray getArray(int rowId) {
        throw new UnsupportedOperationException();
    }

    public ColumnarMap getMap(int rowId) {
        throw new UnsupportedOperationException();
    }

    public ColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException();
    }

    private static DataType fromArrowType(ArrowType arrowType) {
        switch (arrowType.getTypeID()) {
            case Int: {
                return DataTypes.LongType;
            }
            case Bool: {
                return DataTypes.BooleanType;
            }
            case FloatingPoint: {
                return DataTypes.DoubleType;
            }
            case Binary: {
                return DataTypes.BinaryType;
            }
            case Utf8: {
                return DataTypes.StringType;
            }
            case Date: {
                return DataTypes.DateType;
            }
            case Time: 
            case Timestamp: {
                return DataTypes.TimestampType;
            }
            case Decimal: {
                return DataTypes.createDecimalType();
            }
        }
        throw new UnsupportedOperationException("Unsupported data type " + arrowType.toString());
    }

    private static DataType fromArrowField(Field field) {
        if (field.getType().getTypeID() == ArrowType.ArrowTypeID.List) {
            Field elementField = (Field)field.getChildren().get(0);
            DataType elementType = ArrowSchemaConverter.fromArrowField(elementField);
            return new ArrayType(elementType, elementField.isNullable());
        }
        if (field.getType().getTypeID() == ArrowType.ArrowTypeID.Struct) {
            List fieldChildren = field.getChildren();
            StructField[] structFields = new StructField[fieldChildren.size()];
            int ind = 0;
            for (Field childField : field.getChildren()) {
                DataType childType = ArrowSchemaConverter.fromArrowField(childField);
                structFields[ind++] = new StructField(childField.getName(), childType, childField.isNullable(), Metadata.empty());
            }
            return new StructType(structFields);
        }
        return ArrowSchemaConverter.fromArrowType(field.getType());
    }

    ArrowSchemaConverter(ValueVector vector) {
        super(ArrowSchemaConverter.fromArrowField(vector.getField()));
    }

    public static ArrowSchemaConverter newArrowSchemaConverter(ValueVector vector, StructField userProvidedField) {
        if (vector instanceof BitVector) {
            return new BooleanAccessor((BitVector)vector);
        }
        if (vector instanceof BigIntVector) {
            return new LongAccessor((BigIntVector)vector);
        }
        if (vector instanceof Float8Vector) {
            return new DoubleAccessor((Float8Vector)vector);
        }
        if (vector instanceof DecimalVector) {
            return new DecimalAccessor((DecimalVector)vector);
        }
        if (vector instanceof Decimal256Vector) {
            return new Decimal256Accessor((Decimal256Vector)vector);
        }
        if (vector instanceof VarCharVector) {
            return new StringAccessor((VarCharVector)vector);
        }
        if (vector instanceof VarBinaryVector) {
            return new BinaryAccessor((VarBinaryVector)vector);
        }
        if (vector instanceof DateDayVector) {
            return new DateAccessor((DateDayVector)vector);
        }
        if (vector instanceof TimeMicroVector) {
            return new TimeMicroVectorAccessor((TimeMicroVector)vector);
        }
        if (vector instanceof TimeStampMicroVector) {
            return new TimestampMicroVectorAccessor((TimeStampMicroVector)vector);
        }
        if (vector instanceof TimeStampMicroTZVector) {
            return new TimestampMicroTZVectorAccessor((TimeStampMicroTZVector)vector);
        }
        if (vector instanceof ListVector) {
            ListVector listVector = (ListVector)vector;
            return new ArrayAccessor(listVector, userProvidedField);
        }
        if (vector instanceof StructVector) {
            StructVector structVector = (StructVector)vector;
            return new StructAccessor(structVector, userProvidedField);
        }
        throw new UnsupportedOperationException();
    }

    private static class StructAccessor
    extends ArrowSchemaConverter {
        private final StructVector vector;
        private ArrowSchemaConverter[] childColumns;

        StructAccessor(StructVector structVector, StructField userProvidedField) {
            super((ValueVector)structVector);
            this.vector = structVector;
            if (userProvidedField != null) {
                StructType schema = (StructType)SupportedCustomDataType.toSqlType(userProvidedField.dataType());
                List<StructField> structList = Arrays.asList(schema.fields());
                this.childColumns = new ArrowSchemaConverter[structList.size()];
                Map<String, ValueVector> valueVectorMap = structVector.getChildrenFromFields().stream().collect(Collectors.toMap(ValueVector::getName, valueVector -> valueVector));
                for (int i = 0; i < this.childColumns.length; ++i) {
                    StructField structField = structList.get(i);
                    this.childColumns[i] = StructAccessor.newArrowSchemaConverter(valueVectorMap.get(structField.name()), structField);
                }
            } else {
                this.childColumns = new ArrowSchemaConverter[structVector.size()];
                for (int i = 0; i < this.childColumns.length; ++i) {
                    this.childColumns[i] = StructAccessor.newArrowSchemaConverter(structVector.getVectorById(i), null);
                }
            }
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public ColumnVector getChild(int ordinal) {
            return this.childColumns[ordinal];
        }

        @Override
        public void close() {
            if (this.childColumns != null) {
                for (ArrowSchemaConverter v : this.childColumns) {
                    v.close();
                }
                this.childColumns = null;
            }
            this.vector.close();
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class ArrayAccessor
    extends ArrowSchemaConverter {
        private final ListVector vector;
        private final ArrowSchemaConverter arrayData;

        ArrayAccessor(ListVector vector, StructField userProvidedField) {
            super((ValueVector)vector);
            this.vector = vector;
            StructField structField = null;
            if (userProvidedField != null) {
                DataType dataType = userProvidedField.dataType();
                ArrayType arrayType = dataType instanceof MapType ? ArrayAccessor.convertMapTypeToArrayType((MapType)dataType) : (ArrayType)dataType;
                structField = new StructField(vector.getDataVector().getName(), arrayType.elementType(), arrayType.containsNull(), Metadata.empty());
            }
            this.arrayData = ArrayAccessor.newArrowSchemaConverter((ValueVector)vector.getDataVector(), structField);
        }

        static ArrayType convertMapTypeToArrayType(MapType mapType) {
            StructField key = StructField.apply((String)"key", (DataType)mapType.keyType(), (boolean)false, (Metadata)Metadata.empty());
            StructField value = StructField.apply((String)"value", (DataType)mapType.valueType(), (boolean)mapType.valueContainsNull(), (Metadata)Metadata.empty());
            StructField[] fields = new StructField[]{key, value};
            return ArrayType.apply((DataType)new StructType(fields));
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final ColumnarArray getArray(int rowId) {
            ArrowBuf offsets = this.vector.getOffsetBuffer();
            int index = rowId * 4;
            int start = offsets.getInt((long)index);
            int end = offsets.getInt((long)(index + 4));
            return new ColumnarArray((ColumnVector)this.arrayData, start, end - start);
        }

        @Override
        public ColumnarMap getMap(int rowId) {
            ArrowBuf offsets = this.vector.getOffsetBuffer();
            int index = rowId * 4;
            int start = offsets.getInt((long)index);
            int end = offsets.getInt((long)(index + 4));
            ArrowSchemaConverter keys = ((StructAccessor)this.arrayData).childColumns[0];
            ArrowSchemaConverter values = ((StructAccessor)this.arrayData).childColumns[1];
            return new ColumnarMap((ColumnVector)keys, (ColumnVector)values, start, end - start);
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class TimestampMicroTZVectorAccessor
    extends ArrowSchemaConverter {
        private final Optional<Method> rebaseMicrosMethod;
        private final TimeStampMicroTZVector vector;

        TimestampMicroTZVectorAccessor(TimeStampMicroTZVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
            Method rebaseMicrosTmp = null;
            try {
                Class<?> rebaseDateTimeClass = Class.forName("org.apache.spark.sql.catalyst.util.RebaseDateTime");
                rebaseMicrosTmp = rebaseDateTimeClass.getDeclaredMethod("rebaseJulianToGregorianMicros", Long.TYPE);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            this.rebaseMicrosMethod = Optional.ofNullable(rebaseMicrosTmp);
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final long getLong(int rowId) {
            try {
                if (this.rebaseMicrosMethod.isPresent()) {
                    return (Long)this.rebaseMicrosMethod.get().invoke((Object)this.rebaseMicrosMethod.get(), this.vector.get(rowId));
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            return this.vector.get(rowId);
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class TimestampMicroVectorAccessor
    extends ArrowSchemaConverter {
        private static final int ONE_THOUSAND = 1000;
        private static final int ONE_MILLION = 1000000;
        private static final int ONE_BILLION = 1000000000;
        private final TimeStampMicroVector vector;

        TimestampMicroVectorAccessor(TimeStampMicroVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final long getLong(int rowId) {
            return this.vector.get(rowId);
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final UTF8String getUTF8String(int rowId) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            long epoch = this.getLong(rowId);
            long seconds = epoch / 1000000L;
            int nanoOfSeconds = (int)(epoch % 1000000L) * 1000;
            if (nanoOfSeconds < 0) {
                --seconds;
                nanoOfSeconds += 1000000000;
            }
            LocalDateTime dateTime = LocalDateTime.ofEpochSecond(seconds, nanoOfSeconds, ZoneOffset.UTC);
            return UTF8String.fromString((String)dateTime.toString());
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class TimeMicroVectorAccessor
    extends ArrowSchemaConverter {
        private final TimeMicroVector vector;

        TimeMicroVectorAccessor(TimeMicroVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final long getLong(int rowId) {
            return this.vector.get(rowId);
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class DateAccessor
    extends ArrowSchemaConverter {
        private final DateDayVector vector;

        DateAccessor(DateDayVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final int getInt(int rowId) {
            return this.vector.get(rowId);
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class BinaryAccessor
    extends ArrowSchemaConverter {
        private final VarBinaryVector vector;

        BinaryAccessor(VarBinaryVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final byte[] getBinary(int rowId) {
            return this.vector.getObject(rowId);
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class StringAccessor
    extends ArrowSchemaConverter {
        private final VarCharVector vector;

        StringAccessor(VarCharVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final UTF8String getUTF8String(int rowId) {
            if (this.vector.isSet(rowId) == 0) {
                return null;
            }
            ArrowBuf offsets = this.vector.getOffsetBuffer();
            int index = rowId * 4;
            int start = offsets.getInt((long)index);
            int end = offsets.getInt((long)(index + 4));
            return UTF8String.fromAddress(null, (long)(this.vector.getDataBuffer().memoryAddress() + (long)start), (int)(end - start));
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class Decimal256Accessor
    extends ArrowSchemaConverter {
        private final Decimal256Vector vector;

        Decimal256Accessor(Decimal256Vector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public UTF8String getUTF8String(int rowId) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            BigDecimal bigDecimal = this.vector.getObject(rowId);
            return UTF8String.fromString((String)bigDecimal.toPlainString());
        }

        @Override
        public final Decimal getDecimal(int rowId, int precision, int scale) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            return Decimal.apply((BigDecimal)this.vector.getObject(rowId), (int)precision, (int)scale);
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class DecimalAccessor
    extends ArrowSchemaConverter {
        private final DecimalVector vector;

        DecimalAccessor(DecimalVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public byte getByte(int rowId) {
            return this.vector.getObject(rowId).byteValueExact();
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final Decimal getDecimal(int rowId, int precision, int scale) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            return Decimal.apply((BigDecimal)this.vector.getObject(rowId), (int)precision, (int)scale);
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class DoubleAccessor
    extends ArrowSchemaConverter {
        private final Float8Vector vector;

        DoubleAccessor(Float8Vector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final double getDouble(int rowId) {
            return this.vector.get(rowId);
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class LongAccessor
    extends ArrowSchemaConverter {
        private final BigIntVector vector;

        LongAccessor(BigIntVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final byte getByte(int rowId) {
            return (byte)this.getLong(rowId);
        }

        @Override
        public final short getShort(int rowId) {
            return (short)this.getLong(rowId);
        }

        @Override
        public final int getInt(int rowId) {
            return (int)this.getLong(rowId);
        }

        @Override
        public final long getLong(int rowId) {
            return this.vector.get(rowId);
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }

    private static class BooleanAccessor
    extends ArrowSchemaConverter {
        private final BitVector vector;

        BooleanAccessor(BitVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        public final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        @Override
        public final boolean getBoolean(int rowId) {
            return this.vector.get(rowId) == 1;
        }

        @Override
        public final ValueVector vector() {
            return this.vector;
        }
    }
}

