/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.Streams;
import java.util.ServiceLoader;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.types.StructType;
import scala.util.Properties;

public abstract class SparkSqlUtils {
    private static SparkSqlUtils instance;

    public static SparkSqlUtils getInstance() {
        String scalaVersion = Properties.versionNumberString();
        if (instance == null) {
            ServiceLoader<SparkSqlUtils> serviceLoader = ServiceLoader.load(SparkSqlUtils.class);
            instance = Streams.stream(serviceLoader.iterator()).filter(s2 -> s2.supportsScalaVersion(scalaVersion)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not load instance of '%', please check the META-INF/services directory in the connector's jar", SparkSqlUtils.class.getCanonicalName())));
        }
        return instance;
    }

    public abstract boolean supportsScalaVersion(String var1);

    public abstract InternalRow rowToInternalRow(Row var1);

    public abstract ExpressionEncoder<Row> createExpressionEncoder(StructType var1);
}

