/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write.context;

import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Optional;
import com.google.cloud.spark.bigquery.write.context.BigQueryDirectDataWriterContext;
import com.google.cloud.spark.bigquery.write.context.DataWriterContext;
import com.google.cloud.spark.bigquery.write.context.DataWriterContextFactory;
import com.google.cloud.spark.bigquery.write.context.NoOpDataWriterContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class BigQueryDirectDataWriterContextFactory
implements DataWriterContextFactory<InternalRow> {
    private final BigQueryClientFactory writeClientFactory;
    private final String tablePath;
    private final StructType sparkSchema;
    private final ProtoSchema protoSchema;
    private final boolean ignoreInputs;
    private final RetrySettings bigqueryDataWriterHelperRetrySettings;
    private final Optional<String> traceId;
    private final boolean writeAtLeastOnce;

    public BigQueryDirectDataWriterContextFactory(BigQueryClientFactory writeClientFactory, String tablePath, StructType sparkSchema, ProtoSchema protoSchema, boolean ignoreInputs, RetrySettings bigqueryDataWriterHelperRetrySettings, Optional<String> traceId, boolean writeAtLeastOnce) {
        this.writeClientFactory = writeClientFactory;
        this.tablePath = tablePath;
        this.sparkSchema = sparkSchema;
        this.protoSchema = protoSchema;
        this.ignoreInputs = ignoreInputs;
        this.bigqueryDataWriterHelperRetrySettings = bigqueryDataWriterHelperRetrySettings;
        this.traceId = traceId;
        this.writeAtLeastOnce = writeAtLeastOnce;
    }

    @Override
    public DataWriterContext<InternalRow> createDataWriterContext(int partitionId, long taskId, long epochId) {
        if (this.ignoreInputs) {
            return new NoOpDataWriterContext();
        }
        return new BigQueryDirectDataWriterContext(partitionId, taskId, epochId, this.writeClientFactory, this.tablePath, this.sparkSchema, this.protoSchema, this.bigqueryDataWriterHelperRetrySettings, this.traceId, this.writeAtLeastOnce);
    }
}

