/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.UserAgentProvider;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.InjectorBuilder;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.metrics.SparkBigQueryConnectorMetricsUtils;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Schema;
import com.google.cloud.spark.bigquery.repackaged.com.google.inject.Injector;
import com.google.cloud.spark.bigquery.v2.BigQueryTableCreator;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.types.StructType;

public class Spark3Util {
    public static Table createBigQueryTableInstance(BigQueryTableCreator bigQueryTableCreator, StructType sparkProvidedSchema, Map<String, String> properties) {
        Injector injector = new InjectorBuilder().withOptions(properties).withSchema(sparkProvidedSchema).withTableIsMandatory(true).withDataSourceVersion(DataSourceVersion.V2).build();
        BigQueryClient bigQueryClient = injector.getInstance(BigQueryClient.class);
        SparkBigQueryConfig config = injector.getInstance(SparkBigQueryConfig.class);
        SparkContext sparkContext = injector.getInstance(SparkSession.class).sparkContext();
        SparkBigQueryConnectorMetricsUtils.postInputFormatEvent(sparkContext);
        UserAgentProvider userAgentProvider = injector.getInstance(UserAgentProvider.class);
        SparkBigQueryConnectorMetricsUtils.postConnectorVersion(sparkContext, userAgentProvider.getConnectorInfo());
        Supplier<StructType> schemaSupplier = () -> {
            if (sparkProvidedSchema != null) {
                return sparkProvidedSchema;
            }
            Schema schemaFromTable = bigQueryClient.getReadTableSchema(config.toReadTableOptions());
            return schemaFromTable != null ? SchemaConverters.from(SchemaConvertersConfiguration.from(config)).toSpark(schemaFromTable) : null;
        };
        return bigQueryTableCreator.create(injector, schemaSupplier);
    }
}

