/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.spark.bigquery.v2.BigQueryInputPartition;
import com.google.cloud.spark.bigquery.v2.Spark31BigQueryScanBuilder;
import com.google.cloud.spark.bigquery.v2.Spark32BigQueryPartitionReaderFactory;
import com.google.cloud.spark.bigquery.v2.context.ArrowInputPartitionContext;
import com.google.cloud.spark.bigquery.v2.context.BigQueryDataSourceReaderContext;
import com.google.cloud.spark.bigquery.v2.customMetrics.SparkBigQueryBytesReadMetric;
import com.google.cloud.spark.bigquery.v2.customMetrics.SparkBigQueryNumberOfReadStreamsMetric;
import com.google.cloud.spark.bigquery.v2.customMetrics.SparkBigQueryParseTimeMetric;
import com.google.cloud.spark.bigquery.v2.customMetrics.SparkBigQueryRowsReadMetric;
import com.google.cloud.spark.bigquery.v2.customMetrics.SparkBigQueryScanTimeMetric;
import com.google.cloud.spark.bigquery.v2.customMetrics.SparkBigQueryTimeInSparkMetric;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.SupportsRuntimeFiltering;
import org.apache.spark.sql.sources.Filter;

public class Spark32BigQueryScanBuilder
extends Spark31BigQueryScanBuilder
implements SupportsRuntimeFiltering {
    public Spark32BigQueryScanBuilder(BigQueryDataSourceReaderContext ctx) {
        super(ctx);
    }

    public NamedReference[] filterAttributes() {
        ImmutableList<String> partitionFields = BigQueryUtil.getPartitionFields(this.ctx.getTableInfo());
        ImmutableList<String> clusteringFields = BigQueryUtil.getClusteringFields(this.ctx.getTableInfo());
        ImmutableSet.Builder filterFieldsBuilder = ImmutableSet.builder();
        filterFieldsBuilder.addAll(partitionFields);
        filterFieldsBuilder.addAll(clusteringFields);
        ImmutableCollection filterFields = filterFieldsBuilder.build();
        return (NamedReference[])Arrays.stream(this.ctx.readSchema().fieldNames()).filter(((ImmutableSet)filterFields)::contains).map(Expressions::column).toArray(NamedReference[]::new);
    }

    public void filter(Filter[] filters) {
        Optional<List<ArrowInputPartitionContext>> newInputPartitionContexts = this.ctx.filter(filters);
        newInputPartitionContexts.ifPresent(arrowInputPartitionContexts -> {
            this.partitions = (InputPartition[])arrowInputPartitionContexts.stream().map(BigQueryInputPartition::new).toArray(InputPartition[]::new);
        });
    }

    public CustomMetric[] supportedCustomMetrics() {
        return new CustomMetric[]{new SparkBigQueryBytesReadMetric(), new SparkBigQueryRowsReadMetric(), new SparkBigQueryScanTimeMetric(), new SparkBigQueryParseTimeMetric(), new SparkBigQueryTimeInSparkMetric(), new SparkBigQueryNumberOfReadStreamsMetric()};
    }

    @Override
    public PartitionReaderFactory createReaderFactory() {
        return new Spark32BigQueryPartitionReaderFactory();
    }
}

