/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.InjectorBuilder;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableResult;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.inject.Injector;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.OpenLineage;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.DatasetIdentifier;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.LineageRelationProvider;
import com.google.cloud.spark.bigquery.v2.BaseBigQuerySource;
import com.google.cloud.spark.bigquery.v2.Spark31BigQueryTable;
import com.google.cloud.spark.bigquery.v2.Spark3Util;
import com.google.cloud.spark.bigquery.write.CreatableRelationProviderHelper;
import java.util.Locale;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.ExternalCommandRunner;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class Spark31BigQueryTableProvider
extends BaseBigQuerySource
implements TableProvider,
CreatableRelationProvider,
LineageRelationProvider,
ExternalCommandRunner {
    private static final Transform[] EMPTY_TRANSFORM_ARRAY = new Transform[0];

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        return this.getBigQueryTableInternal((java.util.Map<String, String>)options).schema();
    }

    public Table getTable(StructType schema, Transform[] partitioning, java.util.Map<String, String> properties) {
        return Spark3Util.createBigQueryTableInstance(Spark31BigQueryTable::new, schema, properties);
    }

    protected Table getBigQueryTableInternal(java.util.Map<String, String> properties) {
        return Spark3Util.createBigQueryTableInstance(Spark31BigQueryTable::new, null, properties);
    }

    public boolean supportsExternalMetadata() {
        return false;
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> data) {
        return new CreatableRelationProviderHelper().createRelation(sqlContext, mode, parameters, data, ImmutableMap.of());
    }

    @Override
    public DatasetIdentifier getLineageDatasetIdentifier(String sparkListenerEventName, OpenLineage openLineage, Object sqlContext, Object parameters) {
        java.util.Map properties = JavaConverters.mapAsJavaMap((Map)((CaseInsensitiveMap)parameters));
        Injector injector = new InjectorBuilder().withOptions(properties).build();
        SparkBigQueryConfig config = injector.getInstance(SparkBigQueryConfig.class);
        TableId tableId = config.getTableIdWithExplicitProject();
        return new DatasetIdentifier(BigQueryUtil.friendlyTableName(tableId), "bigquery");
    }

    public String[] executeCommand(String command, CaseInsensitiveStringMap options) {
        String trimmedCommand = command.trim().toUpperCase(Locale.ROOT);
        if (trimmedCommand.startsWith("SELECT") || trimmedCommand.startsWith("WITH")) {
            throw new IllegalArgumentException("SELECT and WITH statements are not supported for EXECUTE IMMEDIATE. Please use spark.read.format(\"bigquery\").load(command) instead.");
        }
        Injector injector = new InjectorBuilder().withTableIsMandatory(false).withOptions((java.util.Map<String, String>)options).build();
        BigQueryClient bqClient = injector.getInstance(BigQueryClient.class);
        TableResult result = bqClient.query(command);
        return BigQueryUtil.formatTableResult(result, false);
    }
}

