/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc;

class JdbcUrlSanitizer {
    private static final String SLASH_DELIMITER_USER_PASSWORD_REGEX = "[A-Za-z0-9_%]+//?[A-Za-z0-9_%]*@";
    private static final String COLON_DELIMITER_USER_PASSWORD_REGEX = "([/|,])[A-Za-z0-9_%]+:?[A-Za-z0-9_%]*@";
    private static final String PARAMS_USER_PASSWORD_REGEX = "(?i)[,;&:]?(?:user|username|password)=[^,;&:()]+[,;&:]?";
    private static final String DUPLICATED_DELIMITERS = "(\\(\\)){2,}|[,;&:]{2,}";
    private static final String QUERY_PARAMS_REGEX = "\\?.*$";

    JdbcUrlSanitizer() {
    }

    public static String dropSensitiveData(String jdbcUrl) {
        return jdbcUrl.replaceAll(SLASH_DELIMITER_USER_PASSWORD_REGEX, "@").replaceAll(COLON_DELIMITER_USER_PASSWORD_REGEX, "$1").replaceAll(PARAMS_USER_PASSWORD_REGEX, "").replaceAll(DUPLICATED_DELIMITERS, "").replaceAll(QUERY_PARAMS_REGEX, "");
    }
}

