/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.namespace.resolver;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.OpenLineageConfig;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.DatasetConfig;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.namespace.resolver.DatasetNamespaceResolver;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.namespace.resolver.DatasetNamespaceResolverLoader;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.DatasetIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DatasetNamespaceCombinedResolver {
    private final List<DatasetNamespaceResolver> resolvers;

    public DatasetNamespaceCombinedResolver(OpenLineageConfig config) {
        this.resolvers = config == null || config.getDatasetConfig() == null ? Collections.emptyList() : DatasetNamespaceResolverLoader.loadDatasetNamespaceResolvers(config.getDatasetConfig());
    }

    public DatasetNamespaceCombinedResolver(DatasetConfig config) {
        this.resolvers = config == null ? Collections.emptyList() : DatasetNamespaceResolverLoader.loadDatasetNamespaceResolvers(config);
    }

    public String resolve(String namespace) {
        for (DatasetNamespaceResolver resolver : this.resolvers) {
            String resolved = resolver.resolve(namespace);
            if (resolved.equals(namespace)) continue;
            return resolved;
        }
        return namespace;
    }

    public DatasetIdentifier resolve(DatasetIdentifier identifier) {
        List<DatasetIdentifier.Symlink> resolvedSymlinks = identifier.getSymlinks().stream().map(s2 -> new DatasetIdentifier.Symlink(s2.getName(), this.resolve(s2.getNamespace()), s2.getType())).collect(Collectors.toList());
        return new DatasetIdentifier(identifier.getName(), this.resolve(identifier.getNamespace()), resolvedSymlinks);
    }

    public URI resolveHost(URI namespace) {
        String resolvedHost = this.resolve(namespace.getHost());
        if (!resolvedHost.equals(namespace.getHost())) {
            try {
                return new URI(namespace.getScheme(), namespace.getUserInfo(), resolvedHost, namespace.getPort(), namespace.getPath(), namespace.getQuery(), namespace.getFragment());
            }
            catch (URISyntaxException e) {
                return namespace;
            }
        }
        return namespace;
    }
}

