/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.grpc.netty;

import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ChannelCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Internal;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ManagedChannelProvider;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.internal.SharedResourcePool;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.NettyChannelBuilder;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.NettyChannelProvider;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.Utils;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;

@Internal
public final class UdsNettyChannelProvider
extends ManagedChannelProvider {
    @Override
    public boolean isAvailable() {
        return Utils.EPOLL_DOMAIN_CLIENT_CHANNEL_TYPE != null;
    }

    @Override
    public int priority() {
        return 3;
    }

    public NettyChannelBuilder builderForAddress(String name, int port) {
        throw new AssertionError((Object)"NettyChannelProvider shadows this implementation");
    }

    public NettyChannelBuilder builderForTarget(String target) {
        throw new AssertionError((Object)"NettyChannelProvider shadows this implementation");
    }

    @Override
    public ManagedChannelProvider.NewChannelBuilderResult newChannelBuilder(String target, ChannelCredentials creds) {
        Preconditions.checkState(this.isAvailable());
        ManagedChannelProvider.NewChannelBuilderResult result = new NettyChannelProvider().newChannelBuilder(target, creds);
        if (result.getChannelBuilder() != null) {
            ((NettyChannelBuilder)result.getChannelBuilder()).eventLoopGroupPool(SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP)).channelType(Utils.EPOLL_DOMAIN_CLIENT_CHANNEL_TYPE, DomainSocketAddress.class);
        }
        return result;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

