/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.stub.readrows;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import javax.annotation.Nonnull;

@InternalApi
public class ReadRowsResumptionStrategy
implements StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse> {
    private long rowsProcessed = 0L;

    @Override
    @Nonnull
    public StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse> createNew() {
        return new ReadRowsResumptionStrategy();
    }

    @Override
    @Nonnull
    public ReadRowsResponse processResponse(ReadRowsResponse response) {
        this.rowsProcessed += response.getRowCount();
        return response;
    }

    @Override
    public ReadRowsRequest getResumeRequest(ReadRowsRequest originalRequest) {
        ReadRowsRequest.Builder resumeRequestBuilder = originalRequest.toBuilder();
        resumeRequestBuilder.setOffset(originalRequest.getOffset() + this.rowsProcessed);
        return resumeRequestBuilder.build();
    }

    @Override
    public boolean canResume() {
        return true;
    }
}

