/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.BetaApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.ObsoleteApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc.CallOptionsUtil;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc.GrpcStatusCode;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.EndpointContext;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.TransportChannel;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.internal.ApiCallContextOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.internal.Headers;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.tracing.BaseApiTracer;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.util.TimeConversionUtils;
import com.google.cloud.spark.bigquery.repackaged.com.google.auth.Credentials;
import com.google.cloud.spark.bigquery.repackaged.com.google.auth.Retryable;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.CallCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.CallOptions;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Channel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Deadline;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Metadata;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Status;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.auth.MoreCallCredentials;
import com.google.cloud.spark.bigquery.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@BetaApi(value="Reference ApiCallContext instead - this class is likely to experience breaking changes")
public final class GrpcCallContext
implements ApiCallContext {
    private static final GrpcStatusCode UNAUTHENTICATED_STATUS_CODE = GrpcStatusCode.of(Status.Code.UNAUTHENTICATED);
    public static final CallOptions.Key<ApiTracer> TRACER_KEY = CallOptions.Key.create("gax.tracer");
    private final Channel channel;
    @Nullable
    private final Credentials credentials;
    private final CallOptions callOptions;
    @Nullable
    private final java.time.Duration timeout;
    @Nullable
    private final java.time.Duration streamWaitTimeout;
    @Nullable
    private final java.time.Duration streamIdleTimeout;
    @Nullable
    private final Integer channelAffinity;
    @Nullable
    private final RetrySettings retrySettings;
    @Nullable
    private final ImmutableSet<StatusCode.Code> retryableCodes;
    private final ImmutableMap<String, List<String>> extraHeaders;
    private final ApiCallContextOptions options;
    private final EndpointContext endpointContext;
    private final boolean isDirectPath;

    public static GrpcCallContext createDefault() {
        return new GrpcCallContext(null, null, CallOptions.DEFAULT, null, null, null, null, ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null, false);
    }

    public static GrpcCallContext of(Channel channel, CallOptions callOptions) {
        return new GrpcCallContext(channel, null, callOptions, null, null, null, null, ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null, false);
    }

    private GrpcCallContext(Channel channel, @Nullable Credentials credentials, CallOptions callOptions, @Nullable java.time.Duration timeout, @Nullable java.time.Duration streamWaitTimeout, @Nullable java.time.Duration streamIdleTimeout, @Nullable Integer channelAffinity, ImmutableMap<String, List<String>> extraHeaders, ApiCallContextOptions options, @Nullable RetrySettings retrySettings, @Nullable Set<StatusCode.Code> retryableCodes, @Nullable EndpointContext endpointContext, boolean isDirectPath) {
        this.channel = channel;
        this.credentials = credentials;
        Preconditions.checkNotNull(callOptions);
        this.callOptions = isDirectPath ? callOptions.withCallCredentials(null) : callOptions;
        this.timeout = timeout;
        this.streamWaitTimeout = streamWaitTimeout;
        this.streamIdleTimeout = streamIdleTimeout;
        this.channelAffinity = channelAffinity;
        this.extraHeaders = Preconditions.checkNotNull(extraHeaders);
        this.options = Preconditions.checkNotNull(options);
        this.retrySettings = retrySettings;
        this.retryableCodes = retryableCodes == null ? null : ImmutableSet.copyOf(retryableCodes);
        this.endpointContext = endpointContext == null ? EndpointContext.getDefaultInstance() : endpointContext;
        this.isDirectPath = isDirectPath;
    }

    @Override
    public GrpcCallContext nullToSelf(ApiCallContext inputContext) {
        GrpcCallContext grpcCallContext;
        if (inputContext == null) {
            grpcCallContext = this;
        } else {
            if (!(inputContext instanceof GrpcCallContext)) {
                throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputContext.getClass().getName());
            }
            grpcCallContext = (GrpcCallContext)inputContext;
        }
        return grpcCallContext;
    }

    @Override
    public GrpcCallContext withCredentials(Credentials newCredentials) {
        Preconditions.checkNotNull(newCredentials);
        CallCredentials callCredentials = MoreCallCredentials.from(newCredentials);
        return new GrpcCallContext(this.channel, newCredentials, this.callOptions.withCallCredentials(callCredentials), this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    @Override
    public GrpcCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull(inputChannel);
        if (!(inputChannel instanceof GrpcTransportChannel)) {
            throw new IllegalArgumentException("Expected GrpcTransportChannel, got " + inputChannel.getClass().getName());
        }
        GrpcTransportChannel transportChannel = (GrpcTransportChannel)inputChannel;
        return new GrpcCallContext(transportChannel.getChannel(), this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext, transportChannel.isDirectPath());
    }

    @Override
    public GrpcCallContext withEndpointContext(EndpointContext endpointContext) {
        Preconditions.checkNotNull(endpointContext);
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, endpointContext, this.isDirectPath);
    }

    @Override
    @ObsoleteApi(value="Use withTimeoutDuration(java.time.Duration) instead")
    public GrpcCallContext withTimeout(@Nullable Duration timeout) {
        return this.withTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(timeout));
    }

    @Override
    public GrpcCallContext withTimeoutDuration(@Nullable java.time.Duration timeout) {
        if (timeout != null && (timeout.isZero() || timeout.isNegative())) {
            timeout = null;
        }
        if (timeout != null && this.timeout != null && this.timeout.compareTo(timeout) <= 0) {
            return this;
        }
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    @Override
    @Nullable
    @ObsoleteApi(value="Use getTimeoutDuration() instead")
    public Duration getTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getTimeoutDuration());
    }

    @Override
    @Nullable
    public java.time.Duration getTimeoutDuration() {
        return this.timeout;
    }

    @Override
    @ObsoleteApi(value="Use withStreamWaitTimeoutDuration(java.time.Duration) instead")
    public GrpcCallContext withStreamWaitTimeout(@Nullable Duration streamWaitTimeout) {
        return this.withStreamWaitTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(streamWaitTimeout));
    }

    @Override
    public GrpcCallContext withStreamWaitTimeoutDuration(@Nullable java.time.Duration streamWaitTimeout) {
        if (streamWaitTimeout != null) {
            Preconditions.checkArgument(streamWaitTimeout.compareTo(java.time.Duration.ZERO) >= 0, "Invalid timeout: < 0 s");
        }
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    @Override
    @ObsoleteApi(value="Use withStreamIdleTimeoutDuration(java.time.Duration) instead")
    public GrpcCallContext withStreamIdleTimeout(@Nullable Duration streamIdleTimeout) {
        return this.withStreamIdleTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(streamIdleTimeout));
    }

    @Override
    public GrpcCallContext withStreamIdleTimeoutDuration(@Nullable java.time.Duration streamIdleTimeout) {
        if (streamIdleTimeout != null) {
            Preconditions.checkArgument(streamIdleTimeout.compareTo(java.time.Duration.ZERO) >= 0, "Invalid timeout: < 0 s");
        }
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    @BetaApi(value="The surface for channel affinity is not stable yet and may change in the future.")
    public GrpcCallContext withChannelAffinity(@Nullable Integer affinity) {
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, affinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    @Override
    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public GrpcCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, newExtraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    @Override
    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    @Override
    public GrpcCallContext withRetrySettings(RetrySettings retrySettings) {
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    @Override
    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    @Override
    public GrpcCallContext withRetryableCodes(Set<StatusCode.Code> retryableCodes) {
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, retryableCodes, this.endpointContext, this.isDirectPath);
    }

    @Override
    public ApiCallContext merge(ApiCallContext inputCallContext) {
        ImmutableSet<StatusCode.Code> newRetryableCodes;
        RetrySettings newRetrySettings;
        Integer newChannelAffinity;
        java.time.Duration newStreamIdleTimeout;
        java.time.Duration newStreamWaitTimeout;
        java.time.Duration newTimeout;
        ApiTracer newTracer;
        Deadline newDeadline;
        Channel newChannel;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof GrpcCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputCallContext.getClass().getName());
        }
        GrpcCallContext grpcCallContext = (GrpcCallContext)inputCallContext;
        Credentials newCredentials = grpcCallContext.credentials;
        if (newCredentials == null) {
            newCredentials = this.credentials;
        }
        if ((newChannel = grpcCallContext.channel) == null) {
            newChannel = this.channel;
        }
        if ((newDeadline = grpcCallContext.callOptions.getDeadline()) == null) {
            newDeadline = this.callOptions.getDeadline();
        }
        boolean newIsDirectPath = grpcCallContext.isDirectPath;
        CallCredentials newCallCredentials = grpcCallContext.callOptions.getCredentials();
        if (newCallCredentials == null) {
            newCallCredentials = this.callOptions.getCredentials();
        }
        if ((newTracer = grpcCallContext.callOptions.getOption(TRACER_KEY)) == null) {
            newTracer = this.callOptions.getOption(TRACER_KEY);
        }
        if ((newTimeout = grpcCallContext.timeout) == null) {
            newTimeout = this.timeout;
        }
        if ((newStreamWaitTimeout = grpcCallContext.streamWaitTimeout) == null) {
            newStreamWaitTimeout = this.streamWaitTimeout;
        }
        if ((newStreamIdleTimeout = grpcCallContext.streamIdleTimeout) == null) {
            newStreamIdleTimeout = this.streamIdleTimeout;
        }
        if ((newChannelAffinity = grpcCallContext.channelAffinity) == null) {
            newChannelAffinity = this.channelAffinity;
        }
        if ((newRetrySettings = grpcCallContext.retrySettings) == null) {
            newRetrySettings = this.retrySettings;
        }
        if ((newRetryableCodes = grpcCallContext.retryableCodes) == null) {
            newRetryableCodes = this.retryableCodes;
        }
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, grpcCallContext.extraHeaders);
        ApiCallContextOptions newOptions = this.options.merge(grpcCallContext.options);
        CallOptions newCallOptions = grpcCallContext.callOptions.withCallCredentials(newCallCredentials).withDeadline(newDeadline);
        if (newTracer != null) {
            newCallOptions = newCallOptions.withOption(TRACER_KEY, newTracer);
        }
        return new GrpcCallContext(newChannel, newCredentials, newCallOptions, newTimeout, newStreamWaitTimeout, newStreamIdleTimeout, newChannelAffinity, newExtraHeaders, newOptions, newRetrySettings, newRetryableCodes, this.endpointContext, newIsDirectPath);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public CallOptions getCallOptions() {
        return this.callOptions;
    }

    @Override
    @Nullable
    @ObsoleteApi(value="Use getStreamWaitTimeoutDuration() instead")
    public Duration getStreamWaitTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getStreamWaitTimeoutDuration());
    }

    @Override
    @Nullable
    public java.time.Duration getStreamWaitTimeoutDuration() {
        return this.streamWaitTimeout;
    }

    @Override
    @Nullable
    @ObsoleteApi(value="Use getStreamIdleTimeoutDuration() instead")
    public Duration getStreamIdleTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getStreamIdleTimeoutDuration());
    }

    @Override
    @Nullable
    public java.time.Duration getStreamIdleTimeoutDuration() {
        return this.streamIdleTimeout;
    }

    @Nullable
    public Integer getChannelAffinity() {
        return this.channelAffinity;
    }

    @Override
    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    @ObsoleteApi(value="Use withTransportChannel() instead")
    public GrpcCallContext withChannel(Channel newChannel) {
        return new GrpcCallContext(newChannel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    public GrpcCallContext withCallOptions(CallOptions newCallOptions) {
        return new GrpcCallContext(this.channel, this.credentials, newCallOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    public GrpcCallContext withRequestParamsDynamicHeaderOption(String requestParams) {
        CallOptions newCallOptions = CallOptionsUtil.putRequestParamsDynamicHeaderOption(this.callOptions, requestParams);
        return this.withCallOptions(newCallOptions);
    }

    @Override
    @Nonnull
    public ApiTracer getTracer() {
        ApiTracer tracer = this.callOptions.getOption(TRACER_KEY);
        if (tracer == null) {
            tracer = BaseApiTracer.getInstance();
        }
        return tracer;
    }

    @Override
    public GrpcCallContext withTracer(@Nonnull ApiTracer tracer) {
        Preconditions.checkNotNull(tracer);
        return this.withCallOptions(this.callOptions.withOption(TRACER_KEY, tracer));
    }

    @Override
    public <T> GrpcCallContext withOption(ApiCallContext.Key<T> key, T value) {
        ApiCallContextOptions newOptions = this.options.withOption(key, value);
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, newOptions, this.retrySettings, this.retryableCodes, this.endpointContext, this.isDirectPath);
    }

    @Override
    public <T> T getOption(ApiCallContext.Key<T> key) {
        return this.options.getOption(key);
    }

    @InternalApi
    public void validateUniverseDomain() {
        try {
            this.endpointContext.validateUniverseDomain(this.credentials, UNAUTHENTICATED_STATUS_CODE);
        }
        catch (IOException e) {
            if (e instanceof Retryable) {
                Retryable retryable = (Retryable)((Object)e);
                throw ApiExceptionFactory.createException("Unable to retrieve the Universe Domain from the Credentials.", e, GrpcStatusCode.of(Status.Code.UNAVAILABLE), retryable.isRetryable());
            }
            throw ApiExceptionFactory.createException("Unable to retrieve the Universe Domain from the Credentials.", e, UNAUTHENTICATED_STATUS_CODE, false);
        }
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcCallContext that = (GrpcCallContext)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.callOptions, that.callOptions) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.streamWaitTimeout, that.streamWaitTimeout) && Objects.equals(this.streamIdleTimeout, that.streamIdleTimeout) && Objects.equals(this.channelAffinity, that.channelAffinity) && Objects.equals(this.extraHeaders, that.extraHeaders) && Objects.equals(this.options, that.options) && Objects.equals(this.retrySettings, that.retrySettings) && Objects.equals(this.retryableCodes, that.retryableCodes) && Objects.equals(this.endpointContext, that.endpointContext);
    }

    Metadata getMetadata() {
        Metadata metadata = new Metadata();
        for (Map.Entry header : this.extraHeaders.entrySet()) {
            String headerKey = (String)header.getKey();
            for (String headerValue : (List)header.getValue()) {
                metadata.put(Metadata.Key.of(headerKey, Metadata.ASCII_STRING_MARSHALLER), headerValue);
            }
        }
        return metadata;
    }
}

