/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.client.googleapis.media;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.googleapis.media.MediaHttpDownloaderProgressListener;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.GenericUrl;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpHeaders;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpResponse;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpTransport;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.OutputStream;

public final class MediaHttpDownloader {
    public static final int MAXIMUM_CHUNK_SIZE = 0x2000000;
    private final HttpRequestFactory requestFactory;
    private final HttpTransport transport;
    private boolean directDownloadEnabled = false;
    private MediaHttpDownloaderProgressListener progressListener;
    private int chunkSize = 0x2000000;
    private long mediaContentLength;
    private DownloadState downloadState = DownloadState.NOT_STARTED;
    private long bytesDownloaded;
    private long lastBytePos = -1L;

    public MediaHttpDownloader(HttpTransport transport, HttpRequestInitializer httpRequestInitializer) {
        this.transport = Preconditions.checkNotNull(transport);
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
    }

    public void download(GenericUrl requestUrl, OutputStream outputStream) throws IOException {
        this.download(requestUrl, null, outputStream);
    }

    public void download(GenericUrl requestUrl, HttpHeaders requestHeaders, OutputStream outputStream) throws IOException {
        Preconditions.checkArgument(this.downloadState == DownloadState.NOT_STARTED);
        requestUrl.put("alt", (Object)"media");
        if (this.directDownloadEnabled) {
            this.updateStateAndNotifyListener(DownloadState.MEDIA_IN_PROGRESS);
            HttpResponse response = this.executeCurrentRequest(this.lastBytePos, requestUrl, requestHeaders, outputStream);
            this.bytesDownloaded = this.mediaContentLength = MoreObjects.firstNonNull(response.getHeaders().getContentLength(), this.mediaContentLength).longValue();
            this.updateStateAndNotifyListener(DownloadState.MEDIA_COMPLETE);
            return;
        }
        while (true) {
            long currentRequestLastBytePos = this.bytesDownloaded + (long)this.chunkSize - 1L;
            if (this.lastBytePos != -1L) {
                currentRequestLastBytePos = Math.min(this.lastBytePos, currentRequestLastBytePos);
            }
            HttpResponse response = this.executeCurrentRequest(currentRequestLastBytePos, requestUrl, requestHeaders, outputStream);
            String contentRange = response.getHeaders().getContentRange();
            long nextByteIndex = this.getNextByteIndex(contentRange);
            this.setMediaContentLength(contentRange);
            if (this.lastBytePos != -1L && this.lastBytePos <= nextByteIndex) {
                this.bytesDownloaded = this.lastBytePos;
                this.updateStateAndNotifyListener(DownloadState.MEDIA_COMPLETE);
                return;
            }
            if (this.mediaContentLength <= nextByteIndex) {
                this.bytesDownloaded = this.mediaContentLength;
                this.updateStateAndNotifyListener(DownloadState.MEDIA_COMPLETE);
                return;
            }
            this.bytesDownloaded = nextByteIndex;
            this.updateStateAndNotifyListener(DownloadState.MEDIA_IN_PROGRESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeCurrentRequest(long currentRequestLastBytePos, GenericUrl requestUrl, HttpHeaders requestHeaders, OutputStream outputStream) throws IOException {
        HttpRequest request = this.requestFactory.buildGetRequest(requestUrl);
        if (requestHeaders != null) {
            request.getHeaders().putAll(requestHeaders);
        }
        if (this.bytesDownloaded != 0L || currentRequestLastBytePos != -1L) {
            StringBuilder rangeHeader = new StringBuilder();
            rangeHeader.append("bytes=").append(this.bytesDownloaded).append("-");
            if (currentRequestLastBytePos != -1L) {
                rangeHeader.append(currentRequestLastBytePos);
            }
            request.getHeaders().setRange(rangeHeader.toString());
        }
        HttpResponse response = request.execute();
        try {
            ByteStreams.copy(response.getContent(), outputStream);
        }
        finally {
            response.disconnect();
        }
        return response;
    }

    private long getNextByteIndex(String rangeHeader) {
        if (rangeHeader == null) {
            return 0L;
        }
        return Long.parseLong(rangeHeader.substring(rangeHeader.indexOf(45) + 1, rangeHeader.indexOf(47))) + 1L;
    }

    public MediaHttpDownloader setBytesDownloaded(long bytesDownloaded) {
        Preconditions.checkArgument(bytesDownloaded >= 0L);
        this.bytesDownloaded = bytesDownloaded;
        return this;
    }

    public MediaHttpDownloader setContentRange(long firstBytePos, long lastBytePos) {
        Preconditions.checkArgument(lastBytePos >= firstBytePos);
        this.setBytesDownloaded(firstBytePos);
        this.lastBytePos = lastBytePos;
        return this;
    }

    @Deprecated
    public MediaHttpDownloader setContentRange(long firstBytePos, int lastBytePos) {
        return this.setContentRange(firstBytePos, (long)lastBytePos);
    }

    private void setMediaContentLength(String rangeHeader) {
        if (rangeHeader == null) {
            return;
        }
        if (this.mediaContentLength == 0L) {
            this.mediaContentLength = Long.parseLong(rangeHeader.substring(rangeHeader.indexOf(47) + 1));
        }
    }

    public boolean isDirectDownloadEnabled() {
        return this.directDownloadEnabled;
    }

    public MediaHttpDownloader setDirectDownloadEnabled(boolean directDownloadEnabled) {
        this.directDownloadEnabled = directDownloadEnabled;
        return this;
    }

    public MediaHttpDownloader setProgressListener(MediaHttpDownloaderProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public MediaHttpDownloaderProgressListener getProgressListener() {
        return this.progressListener;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public MediaHttpDownloader setChunkSize(int chunkSize) {
        Preconditions.checkArgument(chunkSize > 0 && chunkSize <= 0x2000000);
        this.chunkSize = chunkSize;
        return this;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public long getNumBytesDownloaded() {
        return this.bytesDownloaded;
    }

    public long getLastBytePosition() {
        return this.lastBytePos;
    }

    private void updateStateAndNotifyListener(DownloadState downloadState) throws IOException {
        this.downloadState = downloadState;
        if (this.progressListener != null) {
            this.progressListener.progressChanged(this);
        }
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    public double getProgress() {
        return this.mediaContentLength == 0L ? 0.0 : (double)this.bytesDownloaded / (double)this.mediaContentLength;
    }

    public static enum DownloadState {
        NOT_STARTED,
        MEDIA_IN_PROGRESS,
        MEDIA_COMPLETE;

    }
}

